/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function.cast;

import adql.db.DBType;
import adql.query.TextPosition;
import adql.query.operand.ADQLOperand;
import adql.query.operand.NumericConstant;
import adql.query.operand.function.cast.TargetType;

public class StandardTargetType
implements TargetType {
    protected static final DBType.DBDatatype[] STANDARD_DATATYPES = new DBType.DBDatatype[]{DBType.DBDatatype.CHAR, DBType.DBDatatype.VARCHAR, DBType.DBDatatype.INTEGER, DBType.DBDatatype.SMALLINT, DBType.DBDatatype.BIGINT, DBType.DBDatatype.REAL, DBType.DBDatatype.DOUBLE, DBType.DBDatatype.TIMESTAMP, DBType.DBDatatype.POINT, DBType.DBDatatype.CIRCLE, DBType.DBDatatype.POLYGON, DBType.DBDatatype.REGION};
    protected DBType type;
    private TextPosition position = null;

    public StandardTargetType(String typeName) throws NullPointerException, IllegalArgumentException {
        this(typeName, -1);
    }

    public StandardTargetType(String typeName, int length) throws NullPointerException, IllegalArgumentException {
        this(new DBType(StandardTargetType.resolveDatatype(typeName), length));
    }

    public StandardTargetType(DBType type) throws NullPointerException, IllegalArgumentException {
        if (type == null) {
            throw new NullPointerException("Missing target type!");
        }
        this.type = type;
        if (!StandardTargetType.isStandardDatatype(type.type)) {
            throw new IllegalArgumentException("Not a standard ADQL CAST's datatype: \"" + (Object)((Object)type.type) + "\"!");
        }
        if (this.type.length > 0 && type.type != DBType.DBDatatype.CHAR && type.type != DBType.DBDatatype.VARCHAR) {
            throw new IllegalArgumentException("No length allowed for the datatype \"" + (Object)((Object)type.type) + "\"! It is not a variable-length datatype like CHAR, VARCHAR, ...");
        }
        this.position = null;
    }

    public static final String normalizeDatatype(String str) throws NullPointerException {
        if (str == null || str.trim().length() == 0) {
            throw new NullPointerException("Missing datatype name!");
        }
        return str.trim().replaceAll("\\s+", " ").toUpperCase();
    }

    public static final DBType.DBDatatype resolveDatatype(String str) throws NullPointerException, IllegalArgumentException {
        String normDatatype = StandardTargetType.normalizeDatatype(str);
        DBType.DBDatatype resolved = null;
        try {
            resolved = "DOUBLE PRECISION".equals(normDatatype) ? DBType.DBDatatype.DOUBLE : DBType.DBDatatype.valueOf(normDatatype);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Unknown datatype: \"" + str + "\"!");
        }
        return resolved;
    }

    public static boolean isStandardDatatype(DBType.DBDatatype datatype) {
        if (datatype != null) {
            for (DBType.DBDatatype d : STANDARD_DATATYPES) {
                if (d != datatype) continue;
                return true;
            }
        }
        return false;
    }

    public static final DBType.DBDatatype[] getStandardDatatypes() {
        return (DBType.DBDatatype[])STANDARD_DATATYPES.clone();
    }

    public static final DBType.DBDatatype[] getNumericDatatypes() {
        return new DBType.DBDatatype[]{DBType.DBDatatype.SMALLINT, DBType.DBDatatype.INTEGER, DBType.DBDatatype.BIGINT, DBType.DBDatatype.REAL, DBType.DBDatatype.DOUBLE};
    }

    public static final DBType.DBDatatype[] getStringDatatypes() {
        return new DBType.DBDatatype[]{DBType.DBDatatype.CHAR, DBType.DBDatatype.VARCHAR, DBType.DBDatatype.TIMESTAMP};
    }

    public static final DBType.DBDatatype[] getGeometricDatatypes() {
        return new DBType.DBDatatype[]{DBType.DBDatatype.POINT, DBType.DBDatatype.CIRCLE, DBType.DBDatatype.POLYGON, DBType.DBDatatype.REGION};
    }

    @Override
    public boolean isNumeric() {
        for (DBType.DBDatatype d : StandardTargetType.getNumericDatatypes()) {
            if (d != this.type.type) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isString() {
        for (DBType.DBDatatype d : StandardTargetType.getStringDatatypes()) {
            if (d != this.type.type) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isGeometry() {
        for (DBType.DBDatatype d : StandardTargetType.getGeometricDatatypes()) {
            if (d != this.type.type) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.type.type == DBType.DBDatatype.DOUBLE ? "DOUBLE PRECISION" : this.type.type.toString();
    }

    public int getTypeLength() {
        return this.type.length;
    }

    @Override
    public DBType getReturnType() {
        return this.type;
    }

    @Override
    public TargetType getCopy() throws Exception {
        return new StandardTargetType(this.type);
    }

    @Override
    public TextPosition getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(TextPosition newPosition) {
        this.position = newPosition;
    }

    public String toString() {
        return this.toADQL();
    }

    @Override
    public int getNbParameters() {
        return this.type.length > 0 ? 1 : 0;
    }

    @Override
    public ADQLOperand[] getParameters() {
        if (this.type.length > 0) {
            return new ADQLOperand[]{new NumericConstant(this.type.length)};
        }
        return new ADQLOperand[0];
    }

    @Override
    public ADQLOperand getParameter(int indParam) {
        if (this.type.length > 0) {
            return new NumericConstant(this.type.length);
        }
        throw new IndexOutOfBoundsException("Incorrect parameter index: " + indParam + "! Nb max. parameters: " + this.getNbParameters() + ".");
    }

    @Override
    public ADQLOperand setParameter(int indParam, ADQLOperand newParam) {
        if (this.type.length > 0 && indParam == 0) {
            NumericConstant oldLength;
            NumericConstant numericConstant = oldLength = this.type.length > 0 ? new NumericConstant(this.type.length) : null;
            if (newParam == null) {
                this.type = new DBType(this.type.type, -1);
            } else if (newParam instanceof NumericConstant) {
                this.type = new DBType(this.type.type, (int)((NumericConstant)newParam).getNumericValue());
            } else {
                throw new IllegalArgumentException("Impossible to replace a datatype length with a " + newParam.getClass().getName() + "! A NumericConstant was expected.");
            }
            return oldLength;
        }
        throw new IndexOutOfBoundsException("Incorrect parameter index: " + indParam + "! Nb max. parameters: " + this.getNbParameters() + ".");
    }

    @Override
    public String toADQL() {
        if (this.type.length > 0) {
            return this.getName() + "(" + this.type.length + ")";
        }
        return this.getName();
    }
}

