      dimension e(240)
      character*15 evapfile
      Write(6,1002)
 1002 Format(///1x,'EVAP Version: 95.01'////
     11x,'Centre for Research on Environmental Systems and Statistics'/
     21x,'Lancaster University, Lancaster LA1 4YQ, UK')
      Write(6,602)
  602 format(/1x,'                       Press return to continue'/)
      Read(5,*)
      Write(6,600)
  600 Format(' *****************************************************'/
     1       ' *  Potential Evapotranspiration Generation Program  *'/
     1       ' *      Based on anual and daily sine curves         *'/
     1       ' *                                                   *'/
     1       ' *  Keith Beven, Lancaster University, 1995          *'/
     1       ' *****************************************************'//
     1       '  Input Start Day Number from January 1st (1 - 365) : ')
      Read(5,*)NStart
      Write(6,601)
  601 Format('  Input Number of Days to be generated : ')
      Read(5,*)Ndays
      Write(6,602)
  602 Format('  Input Length of Time Step in hours : ')
      Read(5,*)Dt
      If(DT.GT.24.)GoTo 498
      Write(6,603)
  603 Format('  Input Daily PET at summer maximum in mm/day : ')
      Read(5,*)Emax
      Write(6,604)
  604 Format('  Input Daily PET at winter minimum im mm/day : ')
      Read(5,*)Emin
   30 Write(6,605)
  605 Format('  Input name of output file : ')
      Read(5,*)Evapfile
      Open(8,File=Evapfile, Status='New',Err=499)
      
      NT = INT(24.01/DT)
      Iday = NStart - 1
      CumPE = 0.

      Do 10 I = 1, NDays
      Iday = Iday + 1
      Fac = 1 + SIN(6.283185*Float(Iday)/365. - 1.570796)
      DET = Emin + 0.5*(Emax-Emin)*Fac
      DStart = 10 - 2.5*Fac
      Dlength = 6 + 4*Fac
      DFin = DStart + DLength
      If(NT.EQ.1)Then
          Write(8,800)DET
          CumPE = CumPE + DET
      Else
*  Start loop on time steps in each day
          Cum = -1
          CumE = 0.

          Do 20 IT = 1, NT
          If(IT*DT.LT.DStart-0.01.OR.IT*DT.GT.DFin+0.01)Then
              E(IT)=0.
          Else
              Frac = (IT*DT-DStart)/DLength
              CUMT = - COS(Frac*3.14159265)
              E(IT) = 0.5 * DET*(CUMT - CUM)
              CUME = CUME + E(IT)
              CUM = CUMT
          Endif
   20     Continue
          CUMPE = CUMPE + CUME
*      Write(6,606)I, DET, CUME, CUMPE
*  606 Format(I6, 3E12.5)
          Write(8,800)(E(IT),IT=1,NT)
  800 Format(F10.5)
      Endif
   10 CONTINUE
      Emean = CumPE / Ndays
      Write(6,607)Ndays, NStart, CumPE, Emean, Evapfile
  607 Format('  ****************************************'/
     1       '  After ',I6,' days starting at day ',I6/
     1       '  Cumulative Potential ET is ',F10.2/
     1       '  At a mean daily rate of ',F10.3/
     1       '  File name is : ', A/
     1       '  ****************************************')
      Stop

  498 Write(6,609)DT
  609 Format(' *******************************************'/
     1       ' Input value of DT is ',f8.2,' hours'/
     1       ' Must be less than or equal to 24......'//
     1       ' Failing gracefully! Do try again .....'/ 
     1       ' *******************************************')
      Stop

  499 Write(6,608)
  608 Format(' *******************************************'/
     1       ' File already exists!  Try again ...........'/
     1       ' *******************************************')
      GoTo 30
      End
