/* $Id: Cit_let.cpp 272611 2011-04-08 18:57:08Z ucko $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the data definition file
 *   'biblio.asn'.
 */

// standard includes

// generated includes
#include <ncbi_pch.hpp>
#include <objects/biblio/Cit_let.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CCit_let::~CCit_let(void)
{
}


bool CCit_let::GetLabelV1(string* label, TLabelFlags flags) const
{
    // return GetCit().GetLabelV1(label, flags);
    return GetCit().GetLabel(label, flags, eLabel_V1);
}


bool CCit_let::GetLabelV2(string* label, TLabelFlags flags) const
{
    if ( !CanGetType()  ||  GetType() != eType_thesis ) {
        // return GetCit().GetLabel(label, flags, eLabel_V2);
        return false;
    }

    const CCit_book& cit = GetCit();
    const CImprint&  imp = cit.GetImp();

    MaybeAddSpace(label);

    *label += "Thesis " + GetParenthesizedYear(imp.GetDate());

    if (imp.CanGetPub()) {
        SIZE_TYPE pos = label->size();
        *label += ' ';
        if (imp.GetPub().GetLabel(label, flags, eLabel_V1)) { // sic
            // "V1" taken over by MakeAffilStr translation
            NStr::ReplaceInPlace(*label, "\"", "'", pos);
        } else {
            label->resize(pos);
        }
    }

    if (imp.CanGetPrepub()  &&  imp.GetPrepub() == CImprint::ePrepub_in_press) {
        *label += ", In press";
    }

    return true;
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 64, chars: 1875, CRC32: a30ca943 */
