<!--
SPDX-FileCopyrightText: Peter Pentchev <roam@ringlet.net>
SPDX-License-Identifier: BSD-2-Clause
-->

# Multi-buffer editor for binary files with a Vi-like interface

\[[Home][ringlet-home] | [Download][ringlet-download] | [GitLab][gitlab] | [ReadTheDocs][readthedocs]\]

## Overview

Hexer is a multi-buffer editor for binary files for Unix-like systems
that displays its buffer(s) as a hex dump.  The user interface is kept
similar to vi/ex.

All POSIX-compatible environments should be supported.

## Installation

- To unpack hexer (you've probably done this already), type:
``` sh
gunzip < hexer-1.0.7.tar.gz | tar -xvf -
```
  Change into the newly-created hexer-1.0.7/ subdirectory.
- Type `make`.
- If you want a command line version of the builtin calculator "myc",
  type `make myc`.
- Type `make install` to install the binaries and the manual.

## Contact

The `hexer` editor was written by [Sascha Demetrio][demetrio].
It is currently maintained by [Peter Pentchev][roam].
It is developed in [a GitLab repository][gitlab]. This documentation is
hosted at [Ringlet][ringlet-home] with a copy at [ReadTheDocs][readthedocs].

[demetrio]: mailto:demetrio@cs.uni-sb.de "Sascha Demetrio"
[roam]: mailto:roam@ringlet.net "Peter Pentchev"
[gitlab]: https://gitlab.com/hexer/hexer "The hexer GitLab repository"
[readthedocs]: https://hexer.readthedocs.io/ "The hexer ReadTheDocs page"
[ringlet-download]: https://devel.ringlet.net/editors/hexer/download/ "The Ringlet hexer download page"
[ringlet-home]: https://devel.ringlet.net/editors/hexer/ "The Ringlet hexer homepage"
