"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Table = exports.FontDict = exports.CID = exports.PrivateDict = exports.Tag2 = exports.Tag1 = void 0;
exports.Tag1 = "CFF ";
exports.Tag2 = "CFF2";
class PrivateDict {
    constructor() {
        // CFF(2) private dict terms
        this.blueValues = [];
        this.otherBlues = [];
        this.familyBlues = [];
        this.familyOtherBlues = [];
        this.stemSnapH = [];
        this.stemSnapV = [];
        this.blueScale = 0.039625;
        this.blueShift = 7;
        this.blueFuzz = 1;
        this.stdHW = 0;
        this.stdVW = 0;
        this.languageGroup = 0;
        this.expansionFactor = 0;
        this.defaultWidthX = 0;
        this.nominalWidthX = 0;
        // CFF1 specific properties
        this.forceBold = false;
        this.initialRandomSeed = 0;
        // This filed is used only during reading CFF table
        this.localSubroutines = null;
        this.inheritedVsIndex = 0;
    }
}
exports.PrivateDict = PrivateDict;
class CID {
    constructor() {
        // ROS
        this.registry = "Adobe";
        this.ordering = "Identity";
        this.supplement = 0;
    }
}
exports.CID = CID;
class FontDict {
    constructor() {
        this.isFixedPitch = false;
        this.italicAngle = 0;
        this.underlinePosition = -100;
        this.underlineThickness = 50;
        this.paintType = 0;
        this.charStringType = 2;
        this.strokeWidth = 0;
        this.cidFontVersion = 0;
        this.cidFontRevision = 0;
        this.cidFontType = 0;
        this.cidCount = 8720;
    }
}
exports.FontDict = FontDict;
// CFF(2) table
class Table {
    constructor(version) {
        this.version = version;
        this.postScriptFontName = "";
        this.topDict = new FontDict();
    }
}
exports.Table = Table;
//# sourceMappingURL=table.js.map