#define FEENOX_HELP_ONE_LINER     "a cloud-first free no-fee no-X uniX-like finite-element(ish) computational engineering tool"
#define FEENOX_HELP_USAGE         "[options] inputfile [replacement arguments] [petsc options]"
#define FEENOX_HELP_OPTIONS_BASE  "\
  -h, --help         display options and detailed explanations of command-line usage\n\
  -v, --version      display brief version information and exit\n\
  -V, --versions     display detailed version information\n\
  -c, --check        validates if the input file is sane or not\n\
  --pdes             list the types of PROBLEMs that FeenoX can solve, one per line\n\
  --elements_info    output a document with information about the supported element types\n\
  --ast              dump an abstract syntax tree of the input\n\
  --linear           force FeenoX to solve the PDE problem as linear\n\
  --non-linear       force FeenoX to solve the PDE problem as non-linear\n\
"
#define FEENOX_HELP_OPTIONS_PDE   "\
  --progress         print ASCII progress bars when solving PDEs\n\
  --mumps            ask PETSc to use the direct linear solver MUMPS\n\
  --gamg             ask PETSc to use a GAMG-preconditioned iterative linear solver\n\
"
#define FEENOX_HELP_EXTRA          "\
Instructions will be read from standard input if “-” is passed as\n\
inputfile, i.e.\n\
\n\
    $ echo 'PRINT 2+2' | feenox -\n\
    4\n\
\n\
The optional [replacement arguments] part of the command line mean that\n\
each argument after the input file that does not start with an hyphen\n\
will be expanded verbatim in the input file in each occurrence of $1,\n\
$2, etc. For example\n\
\n\
    $ echo 'PRINT $1+$2' | feenox - 3 4\n\
    7\n\
\n\
PETSc and SLEPc options can be passed in [petsc options] (or [options])\n\
as well, with the difference that two hyphens have to be used instead of\n\
only once. For example, to pass the PETSc option -ksp_view the actual\n\
FeenoX invocation should be\n\
\n\
    $ feenox input.fee --ksp_view\n\
\n\
For PETSc options that take values, en equal sign has to be used:\n\
\n\
    $ feenox input.fee --mg_levels_pc_type=sor\n\
\n\
See https://www.seamplex.com/feenox/examples for annotated examples.\n\
"
