#
# Copyright 2012 New Dream Network, LLC (DreamHost)
# Copyright 2013 IBM Corp.
# Copyright 2013 eNovance <licensing@enovance.com>
# Copyright Ericsson AB 2013. All rights reserved
# Copyright 2014 Hewlett-Packard Company
# Copyright 2015 Huawei Technologies Co., Ltd.
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

from aodh.api.controllers.v2 import alarms
from aodh.api.controllers.v2 import capabilities
from aodh.api.controllers.v2 import metrics
from aodh.api.controllers.v2 import query
from aodh.api.controllers.v2 import quotas


class V2Controller:
    """Version 2 API controller root."""

    alarms = alarms.AlarmsController()
    query = query.QueryController()
    capabilities = capabilities.CapabilitiesController()
    quotas = quotas.QuotasController()
    metrics = metrics.MetricsController()
