from typing_extensions import TypedDict

from napari._pydantic_compat import Field
from napari.settings._base import EventedSettings
from napari.utils.translations import trans


class PluginHookOption(TypedDict):
    """Custom type specifying plugin, hook implementation function name, and enabled state."""

    plugin: str
    enabled: bool


CallOrderDict = dict[str, list[PluginHookOption]]


class PluginsSettings(EventedSettings):
    disabled_plugins: set[str] = Field(
        set(),
        title=trans._('Disabled plugins'),
        description=trans._(
            'Plugins to disable on application start.',
        ),
    )
    extension2reader: dict[str, str] = Field(
        default_factory=dict,
        title=trans._('File extension readers'),
        description=trans._(
            'Assign file extensions to specific reader plugins'
        ),
    )
    extension2writer: dict[str, str] = Field(
        default_factory=dict,
        title=trans._('Writer plugin extension association.'),
        description=trans._(
            'Assign file extensions to specific writer plugins'
        ),
    )

    class Config:
        use_enum_values = False

    class NapariConfig:
        # Napari specific configuration
        preferences_exclude = (
            'schema_version',
            'disabled_plugins',
            'extension2writer',
        )
