C (C) Copyright 1996-2016 ECMWF.
C 
C This software is licensed under the terms of the Apache Licence Version 2.0
C which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
C In applying this licence, ECMWF does not waive the privileges and immunities 
C granted to it by virtue of its status as an intergovernmental organisation nor
C does it submit to any jurisdiction.
C

	PROGRAM GRAF04
C
C	THIS ROUTINE DEMONSTRATES THE PLOTTING OF CURVES ON DATE/TIME AIXS
C
	CALL POPEN
      CALL PARSE_COMMAND_LINE ('graf04')
C
C	CURVE WITH DATE AXIS
C
	CALL CURVE
	CALL PNEW('PAGE')
C
C	BARS WITH DATE AXIS
C
	CALL BARS
	CALL PNEW('PAGE')
C
C	AREA WITH DATE AXIS
C
	CALL AREA

	CALL PCLOSE
	END
	SUBROUTINE CURVE
C
C	THIS ROUTINE DEMONSTRATES THE PLOTTING OF CURVES ON DATE/TIME AIXS
C
C	THE x AXIS IS A DATE/TIME AXIS FROM 25/6/91 TO 10/7/91
C
	CHARACTER*10 CXVAL
	DIMENSION CXVAL(10),YVAL(10)
	DATA YVAL /5.0,8.,10.,21.,25.,33.,23.,12.,3.,10./
	DATA CXVAL /'1991-05-26','1991-05-28','1991-05-29','1991-05-31',
     X '1991-06-01','1991-06-03','1991-06-05','1991-06-06','1991-06-07',
     X '1991-06-09'/

	CALL PSETC ('SUBPAGE_MAP_PROJECTION','NONE')
	CALL PSETR ('SUBPAGE_Y_POSITION',3.0)
	CALL PSETR ('SUBPAGE_Y_LENGTH',15.0)
	CALL PSETC ('AXIS_TYPE','DATE')
	CALL PSETC ('AXIS_DATE_TYPE','DAYS')
	CALL PSETC ('AXIS_DATE_MIN_VALUE','1991-05-25')
	CALL PSETC ('AXIS_DATE_MAX_VALUE','1991-06-10')
	CALL PAXIS
	CALL PSETC ('AXIS_ORIENTATION','VERTICAL')
	CALL PSETC ('AXIS_POSITION','LEFT')
	CALL PSETC ('AXIS_TYPE','REGULAR')
	CALL PSETR ('AXIS_MIN_VALUE',0.0)
	CALL PSETR ('AXIS_MAX_VALUE',40.0)
	CALL PAXIS
C
C	SET CURVE VALUES
C
	CALL PSETC ('GRAPH_TYPE','CURVE')
	CALL PSET1C ('GRAPH_CURVE_DATE_X_VALUES',CXVAL,10)
	CALL PSET1R ('GRAPH_CURVE_Y_VALUES',YVAL,10)
	CALL PSETI ('GRAPH_LINE_THICKNESS',2)
	CALL PSETC ('GRAPH_LINE_COLOUR','RED')
	CALL PGRAPH
C
C	GENERATE TEXT FOR TITLE
C
	CALL PSETC ('TEXT_JUSTIFICATION','CENTRE')
	CALL PSETC ('TEXT_LINE_1',
     1 'GRAPH Plotting - Example of Curve on DATE/TIME Axis')
	CALL PTEXT

	END
	SUBROUTINE BARS
C
C	THIS ROUTINE DEMONSTRATES THE PLOTTING OF BARS ON DATE/TIME AIXS
C
C	THE X AXIS IS A DATE/TIME AXIS FROM 25/6/91 TO 10/7/91
C
	CHARACTER*10 CXVAL
	DIMENSION CXVAL(10),YLOW(10),YUP(10)
	DATA YLOW /5.,8.,10.,21.,25.,33.,23.,12.,3.,10./
	DATA YUP /8.,10.,21.,25.,33.,23.,12.,3.,10.,5./
	DATA CXVAL /'1991-05-26','1991-05-28','1991-05-29','1991-05-31',
     X '1991-06-01','1991-06-03','1991-06-05','1991-06-06','1991-06-07',
     X '1991-06-09'/

	CALL PSETC ('SUBPAGE_MAP_PROJECTION','NONE')
	CALL PSETR ('SUBPAGE_Y_POSITION',3.0)
	CALL PSETR ('SUBPAGE_Y_LENGTH',15.0)
	CALL PSETC ('AXIS_ORIENTATION','HORIZONTAL')
	CALL PSETC ('AXIS_POSITION','BOTTOM')
	CALL PSETC ('AXIS_TYPE','DATE')
	CALL PSETC ('AXIS_DATE_TYPE','DAYS')
	CALL PSETC ('AXIS_DATE_MIN_VALUE','1991-05-25')
	CALL PSETC ('AXIS_DATE_MAX_VALUE','1991-06-10')
	CALL PAXIS
	CALL PSETC ('AXIS_ORIENTATION','VERTICAL')
	CALL PSETC ('AXIS_POSITION','LEFT')
	CALL PSETC ('AXIS_TYPE','REGULAR')
	CALL PSETR ('AXIS_MIN_VALUE',0.0)
	CALL PSETR ('AXIS_MAX_VALUE',40.0)
	CALL PAXIS
C
C	SET BAR VALUES
C
	CALL PSETC ('GRAPH_TYPE','BAR')
	CALL PSETC ('GRAPH_SHADE','ON')
	CALL PSETC ('GRAPH_SHADE_STYLE','AREA_FILL')
	CALL PSET1C ('GRAPH_BAR_DATE_X_VALUES',CXVAL,10)
	CALL PSET1R ('GRAPH_BAR_Y_LOWER_VALUES',YLOW,10)
	CALL PSET1R ('GRAPH_BAR_Y_UPPER_VALUES',YUP,10)
	CALL PSETC ('GRAPH_SHADE_COLOUR','RED')
	CALL PGRAPH
C
C	GENERATE TEXT FOR TITLE
C
	CALL PSETC ('TEXT_JUSTIFICATION','CENTRE')
	CALL PSETC ('TEXT_LINE_1',
     1 'GRAPH Plotting - Example of Bars on DATE/TIME Axis')
	CALL PTEXT

	END
	SUBROUTINE AREA
C
C	THIS ROUTINE DEMONSTRATES THE PLOTTING OF AREA ON DATE/TIME AIXS
C
C	THE X AXIS IS A DATE/TIME AXIS FROM 25/6/91 TO 10/7/91
C
	CHARACTER*10 CXVAL
	DIMENSION CXVAL(10),Y(10),Y2(10)
	DATA Y /5.,8.,10.,21.,25.,33.,23.,12.,3.,10./
	DATA Y2 /8.,10.,21.,25.,33.,23.,12.,3.,10.,5./
	DATA CXVAL /'1991-05-26','1991-05-28','1991-05-29','1991-05-31',
     X '1991-06-01','1991-06-03','1991-06-05','1991-06-06','1991-06-07',
     X '1991-06-09'/

	CALL PSETC ('SUBPAGE_MAP_PROJECTION','NONE')
	CALL PSETR ('SUBPAGE_Y_POSITION',3.0)
	CALL PSETR ('SUBPAGE_Y_LENGTH',15.0)
	CALL PSETC ('AXIS_ORIENTATION','HORIZONTAL')
	CALL PSETC ('AXIS_POSITION','BOTTOM')
	CALL PSETC ('AXIS_TYPE','DATE')
	CALL PSETC ('AXIS_DATE_TYPE','DAYS')
	CALL PSETC ('AXIS_DATE_MIN_VALUE','1991-05-25')
	CALL PSETC ('AXIS_DATE_MAX_VALUE','1991-06-10')
	CALL PAXIS
	CALL PSETC ('AXIS_ORIENTATION','VERTICAL')
	CALL PSETC ('AXIS_POSITION','LEFT')
	CALL PSETC ('AXIS_TYPE','REGULAR')
	CALL PSETR ('AXIS_MIN_VALUE',0.0)
	CALL PSETR ('AXIS_MAX_VALUE',40.0)
	CALL PAXIS
C
C	SET AREA VALUES
C
	CALL PSETC ('GRAPH_TYPE','AREA')
	CALL PSETC ('GRAPH_SHADE','ON')
	CALL PSETC ('GRAPH_SHADE_STYLE','AREA_FILL')
	CALL PSET1C ('GRAPH_CURVE_DATE_X_VALUES',CXVAL,10)
	CALL PSET1R ('GRAPH_CURVE_Y_VALUES',Y,10)
	CALL PSET1C ('GRAPH_CURVE2_DATE_X_VALUES',CXVAL,10)
	CALL PSET1R ('GRAPH_CURVE2_Y_VALUES',Y2,10)
	CALL PSETC ('GRAPH_SHADE_COLOUR','RED')
	CALL PGRAPH
C
C	GENERATE TEXT FOR TITLE
C
	CALL PSETC ('TEXT_JUSTIFICATION','CENTRE')
	CALL PSETC ('TEXT_LINE_1',
     1 'GRAPH Plotting - Example of Area on DATE/TIME Axis')
	CALL PTEXT

	END


C --------------------------------------------------------------------
C     PARSE_COMMAND_LINE
C     Checks the command-line for any arguments.
C     Arguments can come in pairs. Currently supported arguments are:
C     PROJECTION <CYLINDRICAL | POLAR_STEREOGRAPHIC>
C     DEVICE <PS | SVG | PNG>
C     e.g. Run the program with:
C       <progname> PROJECTION CYLINDRICAL  DEVICE SVG
C --------------------------------------------------------------------

      SUBROUTINE PARSE_COMMAND_LINE (OUTROOTNAME)

      CHARACTER*32 ARG
      CHARACTER*64 ID_TEXT
      CHARACTER*32 PROJECTION
      CHARACTER*32 DEVICE
      CHARACTER*48 EXENAME
      CHARACTER*8  MINIMAL
      CHARACTER*8  SEPARATOR
      CHARACTER*64 OUTNAME
      CHARACTER*(*) OUTROOTNAME

      CHARACTER*16 FORMATS_PS_GIF
      DIMENSION    FORMATS_PS_GIF(2)
      DATA         FORMATS_PS_GIF /'PS', 'GIF_ANIMATION'/

      CHARACTER*16 FORMATS_PS_GIF_PDF
      DIMENSION    FORMATS_PS_GIF_PDF(3)
      DATA         FORMATS_PS_GIF_PDF /'PS', 'GIF_ANIMATION', 'PDF'/

      CHARACTER*16 FORMATS_PS_GIF_SVG
      DIMENSION    FORMATS_PS_GIF_SVG(3)
      DATA         FORMATS_PS_GIF_SVG /'PS', 'GIF_ANIMATION', 'SVG'/

      CHARACTER*16 FORMATS_PS_PNG_SVG
      DIMENSION    FORMATS_PS_PNG_SVG(3)
      DATA         FORMATS_PS_PNG_SVG /'PS', 'PNG', 'SVG'/

      CHARACTER*16 FORMATS_PS_GIF_PNG_SVG
      DIMENSION    FORMATS_PS_GIF_PNG_SVG(4)
      DATA         FORMATS_PS_GIF_PNG_SVG /'PS', 'GIF_ANIMATION', 
     +                                     'PNG', 'SVG'/

      CHARACTER*16 FORMATS_ALL
      DIMENSION    FORMATS_ALL(5)
      DATA         FORMATS_ALL /'PS', 'SVG', 'PDF',
     +                          'KML', 'PNG'/

      INTEGER NUM_ARGS
      INTEGER DEVICE_SET

      DEVICE_SET = 0

      ID_TEXT = ''

      NUM_ARGS = IARGC()

      I = 1
C
C  Start GoTo
C
20    IF (I.LE.NUM_ARGS) THEN
          CALL GETARG ( I, ARG )
C
C         Set the projection?
C
          IF (ARG.EQ.'PROJECTION') THEN
              I = I + 1 
              CALL GETARG ( I, PROJECTION ) 
              CALL PSETC ('SUBPAGE_MAP_PROJECTION', PROJECTION)
C
C        Set the device?
C
          ELSEIF (ARG.EQ.'DEVICE') THEN
              I = I + 1 
              CALL GETARG ( I, DEVICE ) 

C             Set the output filename

              IF     (DEVICE.EQ.'PS')  THEN
                OUTNAME = OUTROOTNAME //   '.ps'
                CALL PSETC ('DEVICE',       DEVICE)
                CALL PSETC ('PS_DEVICE',   'ps_a4')
                CALL PSETC ('PS_FILE_NAME', OUTNAME)
              ELSEIF (DEVICE.EQ.'PS_NEW') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'PS')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'EPS') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'EPS')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'GIF') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'GIF_ANIMATION')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
                CALL PSETI ('OUTPUT_GIF_DELAY',     150)
              ELSEIF (DEVICE.EQ.'GIF_MULTI') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'GIF')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PNG') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'PNG')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'JPEG') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'JPEG')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'SVG') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'SVG')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'CSVG') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'CSVG')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'KML') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'KML')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)

              ELSEIF (DEVICE.EQ.'BAD') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'BAD')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)

              ELSEIF (DEVICE.EQ.'PS_GIF') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_PS_GIF, 2)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PS_GIF_PDF') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_PS_GIF_PDF, 3)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PS_GIF_SVG') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_PS_GIF_SVG, 3)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PS_PNG_SVG') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_PS_PNG_SVG, 3)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PS_GIF_PNG_SVG') THEN
                CALL PSET1C ('OUTPUT_FORMATS',
     +                               FORMATS_PS_GIF_PNG_SVG, 4)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'ALL') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_ALL, 5)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSE
                WRITE(*, '(A)') 'BAD DEVICE: ', DEVICE
              ENDIF
            
            DEVICE_SET = 1
C
C        Split the PostScript pages into separate files?
C
          ELSEIF (ARG.EQ.'PS_SPLIT') THEN
                CALL PSETC ('OUTPUT_PS_SPLIT',     'ON')
C
C        Turn on the numbering for the first page?
C
          ELSEIF (ARG.EQ.'FIRST_PAGE_NUMBER') THEN
                CALL PSETC ('OUTPUT_NAME_FIRST_PAGE_NUMBER', 'ON')
C
C         Set the minimal filename number width?
C
          ELSEIF (ARG.EQ.'MINIMAL') THEN
              I = I + 1 
              CALL GETARG (I, MINIMAL) 
              IF     (MINIMAL.EQ.'0')  THEN
                CALL PSETI ('OUTPUT_FILE_MINIMAL_WIDTH', 0)
              ELSEIF (MINIMAL.EQ.'1')  THEN
                CALL PSETI ('OUTPUT_FILE_MINIMAL_WIDTH', 1)
              ELSEIF (MINIMAL.EQ.'2') THEN
                CALL PSETI ('OUTPUT_FILE_MINIMAL_WIDTH', 2)
              ELSEIF (MINIMAL.EQ.'3') THEN
                CALL PSETI ('OUTPUT_FILE_MINIMAL_WIDTH', 3)
              ENDIF
C
C         Set the file number separator?
C
          ELSEIF (ARG.EQ.'SEP') THEN
              I = I + 1 
              CALL GETARG ( I, SEPARATOR ) 
              CALL PSETC ('OUTPUT_FILE_SEPARATOR', SEPARATOR)
C
C        Run using linear contouring?
C
          ELSEIF (ARG.EQ.'LINEAR') THEN
                CALL PSETC ('CONTOUR_METHOD', 'LINEAR')
                CALL PSETC ('PAGE_ID_LINE_USER_TEXT_PLOT', 'ON')
                CALL PSETC ('PAGE_ID_LINE_USER_TEXT', 'LINEAR')
          ENDIF
          I = I + 1 
          GOTO 20
      ENDIF
C
C     If no device has been set, then use PostScript by default
C
      IF (DEVICE_SET.EQ.0) THEN
        OUTNAME = OUTROOTNAME // '.ps'
        CALL PSETC ('PS_DEVICE',    'ps_a4')
        CALL PSETC ('PS_FILE_NAME', OUTNAME)
      ENDIF
C
      END
