# - Find CAIRO
# Find the CAIRO includes and libraries.
# This module defines:
#  CAIRO_FOUND
#  CAIRO_INCLUDE_DIRS
#  CAIRO_LIBRARIES

find_package(PkgConfig QUIET)
pkg_check_modules(CAIRO QUIET cairo)

find_path(CAIRO_INCLUDE_DIR
  NAMES cairo.h
  PATHS ${CAIRO_INCLUDE_DIRS}
  PATH_SUFFIXES cairo
)

if((NOT CAIRO_INCLUDE_DIRS) AND (CAIRO_INCLUDE_DIR))
  set(CAIRO_INCLUDE_DIRS ${CAIRO_INCLUDE_DIR})
elseif(CAIRO_INCLUDE_DIRS AND CAIRO_INCLUDE_DIR)
  list(APPEND CAIRO_INCLUDE_DIRS ${CAIRO_INCLUDE_DIR})
endif()

find_library(CAIRO_LIBRARY
  NAMES ${CAIRO_LIBRARIES} cairo
)

if((NOT CAIRO_LIBRARIES) AND (CAIRO_LIBRARY))
  set(CAIRO_LIBRARIES ${CAIRO_LIBRARY})
elseif(CAIRO_LIBRARIES AND CAIRO_LIBRARY)
  list(APPEND CAIRO_LIBRARIES ${CAIRO_LIBRARY})
endif()

message(VERBOSE "CAIRO_INCLUDE_DIRS=${CAIRO_INCLUDE_DIRS}")
message(VERBOSE "CAIRO_INCLUDE_DIR=${CAIRO_INCLUDE_DIR}")
message(VERBOSE "CAIRO_LIBRARIES=${CAIRO_LIBRARIES}")
message(VERBOSE "CAIRO_LIBRARY=${CAIRO_LIBRARY}")

if((NOT CAIRO_FOUND) AND (CAIRO_INCLUDE_DIRS) AND (CAIRO_LIBRARIES))
  set(CAIRO_FOUND True)
endif()

include(FindPackageHandleStandardArgs)

if(CAIRO_FOUND)
  find_package_handle_standard_args(CAIRO
    REQUIRED_VARS CAIRO_FOUND CAIRO_INCLUDE_DIRS CAIRO_LIBRARIES
    VERSION_VAR CAIRO_VERSION
  )
else()
  find_package_handle_standard_args(CAIRO
    REQUIRED_VARS CAIRO_FOUND
  )
endif()

mark_as_advanced(CAIRO_INCLUDE_DIR CAIRO_LIBRARY)
