// SPDX-License-Identifier: GPL-2.0-or-later
// SPDX-FileCopyrightText: 2010 Konrad Twardowski

#pragma once

#include "../kshutdown.h"

#include <QPlainTextEdit>

class TestAction final: public Action {
public:
	explicit TestAction();
	void initContainerWidget() override;
	virtual bool onAction() override;
	virtual void readConfig() override;
	virtual void writeConfig() override;
private:
	Q_DISABLE_COPY(TestAction)
	QPlainTextEdit *m_textEdit = nullptr;
	QString m_defaultText = "";
};
