/*
 * Copyright 2021-2025 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Java API for validating both formats, converting from the event-based to the
 * hierarchical format (suitable for inclusion in build tools and reporting
 * tools), and generating HTML reports
 *
 * @since 0.2.0
 */
module org.opentest4j.reporting.tooling.core {

    requires static org.apiguardian.api;
    requires com.google.gson;
    requires org.opentest4j.reporting.events;
    requires org.opentest4j.reporting.tooling.spi;

    exports org.opentest4j.reporting.tooling.core.converter;
    exports org.opentest4j.reporting.tooling.core.htmlreport;
    exports org.opentest4j.reporting.tooling.core.validator;

    uses org.opentest4j.reporting.tooling.spi.htmlreport.Contributor;

    provides org.opentest4j.reporting.tooling.spi.htmlreport.Contributor with
            org.opentest4j.reporting.tooling.core.htmlreport.CoreContributor,
            org.opentest4j.reporting.tooling.core.htmlreport.GitContributor,
            org.opentest4j.reporting.tooling.core.htmlreport.JavaContributor;

    opens org.opentest4j.reporting.tooling.core.htmlreport to com.google.gson;
}
