;=========================== begin_copyright_notice ============================
;
; Copyright (C) 2023-2025 Intel Corporation
;
; SPDX-License-Identifier: MIT
;
;============================ end_copyright_notice =============================

; COM: ;;;;;;;;;; RUNNERS ;;;;;;;;;;

; RUN: %opt_typed_ptrs %use_old_pass_manager% -GenXModule -GenXCategoryWrapper -GenXCisaBuilderPass -GenXFinalizer \
; RUN: -march=genx64 -mtriple=spir64-unknown-unknown -finalizer-opts="-dumpcommonisa -isaasmToConsole" -mcpu=XeHPG < %s | FileCheck %s
; RUN: %opt_opaque_ptrs %use_old_pass_manager% -GenXModule -GenXCategoryWrapper -GenXCisaBuilderPass -GenXFinalizer \
; RUN: -march=genx64 -mtriple=spir64-unknown-unknown -finalizer-opts="-dumpcommonisa -isaasmToConsole" -mcpu=XeHPG < %s | FileCheck %s

; COM: ;;;;;;;;;; CHECKERS ;;;;;;;;;;

; CHECK: .decl [[A:V[0-9]+]] v_type=G type=f num_elts=8
; CHECK: .decl [[B:V[0-9]+]] v_type=G type=f num_elts=8
; CHECK: oword_ld (2) T{{[0-9]}} 0x0:ud [[A:[A-z0-9]*]].0
; CHECK: oword_ld (2) T{{[0-9]}} 0x20:ud [[B:[A-z0-9]*]].0
; CHECK: min (M1, 8) [[RES:[A-z0-9]*]](0,0)<1> [[A]](0,0)<1;1,0> [[B]](0,0)<1;1,0>
; CHECK: oword_st (2) T{{[0-9]}} 0x0:ud [[RES]].0

; COM: ;;;;;;;;;; KERNEL ;;;;;;;;;;

declare <8 x float> @llvm.genx.oword.ld.v8f32(i32, i32, i32) #0
declare void @llvm.genx.oword.st.v8f32(i32, i32, <8 x float>) #0

declare <8 x float> @llvm.minnum.v8f32(<8 x float>, <8 x float>)

; Function Attrs: noinline nounwind
define dllexport spir_kernel void @the_test(i32 %0, i32 %1) local_unnamed_addr #1 {
  %a = tail call <8 x float> @llvm.genx.oword.ld.v8f32(i32 0, i32 %0, i32 0) #2
  %b = tail call <8 x float> @llvm.genx.oword.ld.v8f32(i32 0, i32 %0, i32 32) #2
  %res = call <8 x float> @llvm.minnum.v8f32(<8 x float> %a, <8 x float> %b)
  tail call void @llvm.genx.oword.st.v8f32(i32 %1, i32 0, <8 x float> %res) #2
  ret void
}

attributes #0 = { "target-cpu"="XeHPG" }
attributes #1 = { noinline nounwind "CMGenxMain" "VC.Stack.Amount"="0" "target-cpu"="XeHPG" }
attributes #2 = { nounwind }

!spirv.Source = !{!0}
!opencl.spir.version = !{!1}
!opencl.ocl.version = !{!0}
!opencl.used.extensions = !{!2}
!opencl.used.optional.core.features = !{!2}
!spirv.Generator = !{!3}
!genx.kernels = !{!4}
!genx.kernel.internal = !{!8}

!0 = !{i32 0, i32 0}
!1 = !{i32 1, i32 2}
!2 = !{}
!3 = !{i16 6, i16 14}
!4 = !{void (i32, i32)* @the_test, !"the_test", !5, i32 0, !6, !0, !7, i32 0}
!5 = !{i32 2, i32 2}
!6 = !{i32 64, i32 68}
!7 = !{!"buffer_t", !"buffer_t"}
!8 = !{void (i32, i32)* @the_test, null, null, null, null}
