"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MemStats = exports.CpuStats = void 0;
const tslib_1 = require("tslib");
const os = tslib_1.__importStar(require("os"));
function getCpuStats() {
    const cpus = os.cpus();
    let stats = [];
    for (let cpu of cpus) {
        const idle = cpu.times.idle;
        const total = idle + cpu.times.user + cpu.times.nice + cpu.times.irq + cpu.times.sys;
        stats.push({ idle, total });
    }
    return stats;
}
class CpuStats {
    constructor() {
        this.lastGetTime = Date.now();
        this.lastUsage = 0;
        this.lastStat = getCpuStats();
    }
    getTotalCpuUsage() {
        const currentTime = Date.now();
        if (currentTime - this.lastGetTime < 1000) {
            return this.lastUsage;
        }
        else {
            const currentStat = getCpuStats();
            let count = 0, totalUsage = 0;
            for (let j = 0; j < currentStat.length && this.lastStat.length; j++) {
                const idleDiff = currentStat[j].idle - this.lastStat[j].idle;
                const totalDiff = currentStat[j].total - this.lastStat[j].total;
                totalUsage += 1 - idleDiff / totalDiff;
                count += 1;
            }
            this.lastStat = currentStat;
            this.lastGetTime = currentTime;
            const usage = count ? Math.min(1, Math.max(0, totalUsage / count)) : 0;
            this.lastUsage = usage;
            return usage;
        }
    }
}
exports.CpuStats = CpuStats;
class MemStats {
    constructor() {
        this.lastGetTime = Date.now();
        this.lastUsage = 0;
    }
    getMemoryUsage() {
        const currentTime = Date.now();
        if (currentTime - this.lastGetTime < 1000) {
            return this.lastUsage;
        }
        else {
            const totalMem = os.totalmem();
            const freeMem = os.freemem();
            const usage = 1 - freeMem / totalMem;
            this.lastUsage = usage;
            return usage;
        }
    }
}
exports.MemStats = MemStats;
