"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MarkGlyphSets = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const errors_1 = require("@ot-builder/errors");
const coverage_1 = require("../shared/coverage");
exports.MarkGlyphSets = {
    ...(0, bin_util_1.Read)((view, gOrd) => {
        const format = view.uint16();
        errors_1.Assert.FormatSupported("MarkGlyphSetsTable::markGlyphSetTableFormat", format, 1);
        const count = view.uint16();
        const ans = [];
        for (let item = 0; item < count; item++) {
            ans[item] = coverage_1.CovUtils.glyphSetFromGidList(view.ptr32().next(coverage_1.GidCoverage), gOrd);
        }
        return ans;
    }),
    ...(0, bin_util_1.Write)((frag, markGlyphSets, cfg, gOrd) => {
        const trick = cfg.layout.gdefWriteTrick || 0;
        frag.uint16(1);
        frag.uint16(markGlyphSets.length);
        for (const mgs of markGlyphSets) {
            frag.ptr32New().push(coverage_1.GidCoverage, coverage_1.CovUtils.gidListFromGlyphSet(mgs, gOrd), trick);
        }
    })
};
//# sourceMappingURL=mark-glyph-sets.js.map