"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Fallback = Fallback;
exports.ToCount = ToCount;
exports.ArrToCount = ArrToCount;
exports.FlatMatrixSized = FlatMatrixSized;
exports.FlatMatrixAutoSize = FlatMatrixAutoSize;
exports.Zip = Zip;
exports.ZipWithIndex = ZipWithIndex;
exports.ZipWithIndexReverse = ZipWithIndexReverse;
exports.Zip3WithIndex = Zip3WithIndex;
function* Fallback(iter, fallback) {
    for (const x of iter) {
        if (x === undefined)
            yield fallback;
        else
            yield x;
    }
}
function* ToCount(iter, count, fallback) {
    let c = 0;
    for (const x of iter) {
        if (x === undefined)
            yield fallback;
        else
            yield x;
        c += 1;
        if (c >= count)
            return;
    }
    for (; c < count; c++) {
        yield fallback;
    }
}
function ArrToCount(iter, fallback) {
    return ToCount(iter, iter.length, fallback);
}
function* FlatMatrixSized(mat, columns, fallback) {
    var _a;
    const rows = mat.length;
    for (let p = 0; p < rows; p++) {
        const row = mat[p];
        for (let q = 0; q < columns; q++) {
            if (!row)
                yield [fallback, p, q];
            else
                yield [(_a = row[q]) !== null && _a !== void 0 ? _a : fallback, p, q];
        }
    }
}
function FlatMatrixAutoSize(mat, fallback) {
    const rows = mat.length;
    let columns = 0;
    for (let p = 0; p < rows; p++) {
        if (mat[p] && mat[p].length > columns)
            columns = mat[p].length;
    }
    return FlatMatrixSized(mat, columns, fallback);
}
function* Zip(as, bs) {
    if (as.length !== bs.length)
        throw new Error("length mismatch");
    for (let id = 0; id < as.length; id++) {
        yield [as[id], bs[id]];
    }
}
function* ZipWithIndex(as, bs) {
    if (as.length !== bs.length)
        throw new Error("length mismatch");
    for (let id = 0; id < as.length; id++) {
        yield [as[id], bs[id], id];
    }
}
function* ZipWithIndexReverse(as, bs) {
    if (as.length !== bs.length)
        throw new Error("length mismatch");
    for (let id = as.length; id-- > 0;) {
        yield [as[id], bs[id], id];
    }
}
function* Zip3WithIndex(as, bs, cs) {
    if (as.length !== bs.length)
        throw new Error("length mismatch");
    if (as.length !== cs.length)
        throw new Error("length mismatch");
    for (let id = 0; id < as.length; id++) {
        yield [as[id], bs[id], cs[id], id];
    }
}
//# sourceMappingURL=index.js.map