"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SkipWriteGlyphs = exports.SkipReadGlyphs = void 0;
const ot_glyphs_1 = require("@ot-builder/ot-glyphs");
exports.SkipReadGlyphs = {
    readGlyphs(sfnt, cfg, gOrd, ctx) {
        for (let gid = 0; gid < gOrd.length; gid++) {
            const glyph = gOrd.at(gid);
            const hm = ctx.coStat.getHMetric(gid, null);
            if (hm)
                glyph.horizontal = hm;
            const vm = ctx.coStat.getVMetric(gid, null);
            if (vm)
                glyph.vertical = vm;
        }
        return null;
    }
};
exports.SkipWriteGlyphs = {
    writeMetricVariance: true,
    writeGlyphs(sink, cfg, coGlyphs, gOrd, ctx) {
        ctx.stat.setNumGlyphs(gOrd.length);
        for (let gid = 0; gid < gOrd.length; gid++) {
            const glyph = gOrd.at(gid);
            ctx.stat.setMetric(gid, glyph.horizontal, glyph.vertical, ot_glyphs_1.OtGlyph.Stat.BoundingBox.Blank());
        }
        ctx.stat.settle();
    }
};
//# sourceMappingURL=index.js.map