.\" *********************************** start of \input{common.tex}
.\" *********************************** end of \input{common.tex}
'\" t
.\" Manual page created with latex2man on Tue Aug 29 12:09:48 2023
.\" NOTE: This file is generated, DO NOT EDIT.
.de Vb
.ft CW
.nf
..
.de Ve
.ft R

.fi
..
.TH "UNW\\_FLUSH\\_CACHE" "3libunwind" "29 August 2023" "Programming Library " "Programming Library "
.SH NAME
unw_flush_cache
\-\- flush cached info 
.PP
.SH SYNOPSIS

.PP
#include <libunwind.h>
.br
.PP
void
unw_flush_cache(unw_addr_space_t
as,
unw_word_t
lo,
unw_word_t
hi);
.br
.PP
.SH DESCRIPTION

.PP
The unw_flush_cache()
routine flushes all cached info as it 
relates to address range lo
to hi
(non\-inclusive) in the 
target address space as\&.
In addition, all info cached for 
address space as
that is not tied to a particular code range is 
also flushed. For example, the address of the dynamic registration 
list is not tied to a code range and its cached value (if any) is 
flushed by a call to this routine. The address range specified by 
lo
and hi
should be understood as a hint: 
unw_flush_cache()
may flush more information than requested, 
but \fInever\fP
less. In other words, unw_flush_cache()
may 
overflush, but not underflush. 
.PP
As a special case, if arguments lo
and hi
are both 0, all 
information cached on behalf of address space as
is flushed. 
.PP
.SH RETURN VALUE

.PP
The unw_flush_cache()
routine cannot fail and does not 
return a value. 
.PP
.SH THREAD AND SIGNAL SAFETY

.PP
The unw_flush_cache()
routine is thread safe as well as safe to 
use from a signal handler. 
.PP
.SH SEE ALSO

.PP
libunwind(3libunwind),
unw_set_caching_policy(3libunwind)
unw_set_cache_size(3libunwind)
.PP
.SH AUTHOR

.PP
David Mosberger\-Tang
.br
Email: \fBdmosberger@gmail.com\fP
.br
WWW: \fBhttp://www.nongnu.org/libunwind/\fP\&.
.\" NOTE: This file is generated, DO NOT EDIT.
