// SPDX-License-Identifier: GPL-2.0+
#include <asm/arch/ps7_init_gpl.h>

unsigned long ps7_pll_init_data_3_0[] = {
	EMIT_WRITE(0XF8000008, 0x0000DF0DU),
	EMIT_MASKWRITE(0XF8000110, 0x003FFFF0U, 0x001772C0U),
	EMIT_MASKWRITE(0XF8000100, 0x0007F000U, 0x0001A000U),
	EMIT_MASKWRITE(0XF8000100, 0x00000010U, 0x00000010U),
	EMIT_MASKWRITE(0XF8000100, 0x00000001U, 0x00000001U),
	EMIT_MASKWRITE(0XF8000100, 0x00000001U, 0x00000000U),
	EMIT_MASKPOLL(0XF800010C, 0x00000001U),
	EMIT_MASKWRITE(0XF8000100, 0x00000010U, 0x00000000U),
	EMIT_MASKWRITE(0XF8000120, 0x1F003F30U, 0x1F000200U),
	EMIT_MASKWRITE(0XF8000114, 0x003FFFF0U, 0x001DB2C0U),
	EMIT_MASKWRITE(0XF8000104, 0x0007F000U, 0x00015000U),
	EMIT_MASKWRITE(0XF8000104, 0x00000010U, 0x00000010U),
	EMIT_MASKWRITE(0XF8000104, 0x00000001U, 0x00000001U),
	EMIT_MASKWRITE(0XF8000104, 0x00000001U, 0x00000000U),
	EMIT_MASKPOLL(0XF800010C, 0x00000002U),
	EMIT_MASKWRITE(0XF8000104, 0x00000010U, 0x00000000U),
	EMIT_MASKWRITE(0XF8000124, 0xFFF00003U, 0x0C200003U),
	EMIT_MASKWRITE(0XF8000118, 0x003FFFF0U, 0x001F42C0U),
	EMIT_MASKWRITE(0XF8000108, 0x0007F000U, 0x00014000U),
	EMIT_MASKWRITE(0XF8000108, 0x00000010U, 0x00000010U),
	EMIT_MASKWRITE(0XF8000108, 0x00000001U, 0x00000001U),
	EMIT_MASKWRITE(0XF8000108, 0x00000001U, 0x00000000U),
	EMIT_MASKPOLL(0XF800010C, 0x00000004U),
	EMIT_MASKWRITE(0XF8000108, 0x00000010U, 0x00000000U),
	EMIT_WRITE(0XF8000004, 0x0000767BU),
	EMIT_EXIT(),
};

unsigned long ps7_clock_init_data_3_0[] = {
	EMIT_WRITE(0XF8000008, 0x0000DF0DU),
	EMIT_MASKWRITE(0XF8000128, 0x03F03F01U, 0x00203401U),
	EMIT_MASKWRITE(0XF8000138, 0x00000011U, 0x00000001U),
	EMIT_MASKWRITE(0XF8000140, 0x03F03F71U, 0x00100801U),
	EMIT_MASKWRITE(0XF800014C, 0x00003F31U, 0x00000501U),
	EMIT_MASKWRITE(0XF8000150, 0x00003F33U, 0x00000A01U),
	EMIT_MASKWRITE(0XF8000154, 0x00003F33U, 0x00000A01U),
	EMIT_MASKWRITE(0XF8000158, 0x00003F33U, 0x00000502U),
	EMIT_MASKWRITE(0XF800015C, 0x03F03F33U, 0x00501903U),
	EMIT_MASKWRITE(0XF8000160, 0x007F007FU, 0x00000000U),
	EMIT_MASKWRITE(0XF8000168, 0x00003F31U, 0x00000501U),
	EMIT_MASKWRITE(0XF8000170, 0x03F03F30U, 0x00400500U),
	EMIT_MASKWRITE(0XF80001C4, 0x00000001U, 0x00000001U),
	EMIT_MASKWRITE(0XF800012C, 0x01FFCCCDU, 0x01DF844DU),
	EMIT_WRITE(0XF8000004, 0x0000767BU),
	EMIT_EXIT(),
};

unsigned long ps7_ddr_init_data_3_0[] = {
	EMIT_MASKWRITE(0XF8006000, 0x0001FFFFU, 0x00000080U),
	EMIT_MASKWRITE(0XF8006004, 0x0007FFFFU, 0x0000103FU),
	EMIT_MASKWRITE(0XF8006008, 0x03FFFFFFU, 0x03C0780FU),
	EMIT_MASKWRITE(0XF800600C, 0x03FFFFFFU, 0x02001001U),
	EMIT_MASKWRITE(0XF8006010, 0x03FFFFFFU, 0x00014001U),
	EMIT_MASKWRITE(0XF8006014, 0x001FFFFFU, 0x00042E1AU),
	EMIT_MASKWRITE(0XF8006018, 0xF7FFFFFFU, 0x44D154D4U),
	EMIT_MASKWRITE(0XF800601C, 0xFFFFFFFFU, 0xB2024127U),
	EMIT_MASKWRITE(0XF8006020, 0x7FDFFFFCU, 0x2B08B290U),
	EMIT_MASKWRITE(0XF8006024, 0x0FFFFFC3U, 0x00000000U),
	EMIT_MASKWRITE(0XF8006028, 0x00003FFFU, 0x00002007U),
	EMIT_MASKWRITE(0XF800602C, 0xFFFFFFFFU, 0x00000018U),
	EMIT_MASKWRITE(0XF8006030, 0xFFFFFFFFU, 0x00040970U),
	EMIT_MASKWRITE(0XF8006034, 0x13FF3FFFU, 0x00011674U),
	EMIT_MASKWRITE(0XF8006038, 0x00000003U, 0x00000000U),
	EMIT_MASKWRITE(0XF800603C, 0x000FFFFFU, 0x00000777U),
	EMIT_MASKWRITE(0XF8006040, 0xFFFFFFFFU, 0xFFF00000U),
	EMIT_MASKWRITE(0XF8006044, 0x0FFFFFFFU, 0x0F666666U),
	EMIT_MASKWRITE(0XF8006048, 0x0003F03FU, 0x0003C008U),
	EMIT_MASKWRITE(0XF8006050, 0xFF0F8FFFU, 0x77010800U),
	EMIT_MASKWRITE(0XF8006058, 0x00010000U, 0x00000000U),
	EMIT_MASKWRITE(0XF800605C, 0x0000FFFFU, 0x00005003U),
	EMIT_MASKWRITE(0XF8006060, 0x000017FFU, 0x0000003EU),
	EMIT_MASKWRITE(0XF8006064, 0x00021FE0U, 0x00020000U),
	EMIT_MASKWRITE(0XF8006068, 0x03FFFFFFU, 0x00284545U),
	EMIT_MASKWRITE(0XF800606C, 0x0000FFFFU, 0x00001610U),
	EMIT_MASKWRITE(0XF8006078, 0x03FFFFFFU, 0x00466111U),
	EMIT_MASKWRITE(0XF800607C, 0x000FFFFFU, 0x00032222U),
	EMIT_MASKWRITE(0XF80060A4, 0xFFFFFFFFU, 0x10200802U),
	EMIT_MASKWRITE(0XF80060A8, 0x0FFFFFFFU, 0x0670C845U),
	EMIT_MASKWRITE(0XF80060AC, 0x000001FFU, 0x000001FEU),
	EMIT_MASKWRITE(0XF80060B0, 0x1FFFFFFFU, 0x1CFFFFFFU),
	EMIT_MASKWRITE(0XF80060B4, 0x00000200U, 0x00000200U),
	EMIT_MASKWRITE(0XF80060B8, 0x01FFFFFFU, 0x0020006AU),
	EMIT_MASKWRITE(0XF80060C4, 0x00000003U, 0x00000000U),
	EMIT_MASKWRITE(0XF80060C8, 0x000000FFU, 0x00000000U),
	EMIT_MASKWRITE(0XF80060DC, 0x00000001U, 0x00000000U),
	EMIT_MASKWRITE(0XF80060F0, 0x0000FFFFU, 0x00000000U),
	EMIT_MASKWRITE(0XF80060F4, 0x0000000FU, 0x00000008U),
	EMIT_MASKWRITE(0XF8006114, 0x000000FFU, 0x00000000U),
	EMIT_MASKWRITE(0XF8006118, 0x7FFFFFCFU, 0x40000001U),
	EMIT_MASKWRITE(0XF800611C, 0x7FFFFFCFU, 0x40000001U),
	EMIT_MASKWRITE(0XF8006120, 0x7FFFFFCFU, 0x40000001U),
	EMIT_MASKWRITE(0XF8006124, 0x7FFFFFCFU, 0x40000001U),
	EMIT_MASKWRITE(0XF800612C, 0x000FFFFFU, 0x0001D400U),
	EMIT_MASKWRITE(0XF8006130, 0x000FFFFFU, 0x0001C000U),
	EMIT_MASKWRITE(0XF8006134, 0x000FFFFFU, 0x0001BC00U),
	EMIT_MASKWRITE(0XF8006138, 0x000FFFFFU, 0x0001C800U),
	EMIT_MASKWRITE(0XF8006140, 0x000FFFFFU, 0x00000035U),
	EMIT_MASKWRITE(0XF8006144, 0x000FFFFFU, 0x00000035U),
	EMIT_MASKWRITE(0XF8006148, 0x000FFFFFU, 0x00000035U),
	EMIT_MASKWRITE(0XF800614C, 0x000FFFFFU, 0x00000035U),
	EMIT_MASKWRITE(0XF8006154, 0x000FFFFFU, 0x0000007AU),
	EMIT_MASKWRITE(0XF8006158, 0x000FFFFFU, 0x0000007DU),
	EMIT_MASKWRITE(0XF800615C, 0x000FFFFFU, 0x00000080U),
	EMIT_MASKWRITE(0XF8006160, 0x000FFFFFU, 0x0000007EU),
	EMIT_MASKWRITE(0XF8006168, 0x001FFFFFU, 0x000000CAU),
	EMIT_MASKWRITE(0XF800616C, 0x001FFFFFU, 0x000000C5U),
	EMIT_MASKWRITE(0XF8006170, 0x001FFFFFU, 0x000000C4U),
	EMIT_MASKWRITE(0XF8006174, 0x001FFFFFU, 0x000000C7U),
	EMIT_MASKWRITE(0XF800617C, 0x000FFFFFU, 0x000000BAU),
	EMIT_MASKWRITE(0XF8006180, 0x000FFFFFU, 0x000000BDU),
	EMIT_MASKWRITE(0XF8006184, 0x000FFFFFU, 0x000000C0U),
	EMIT_MASKWRITE(0XF8006188, 0x000FFFFFU, 0x000000BEU),
	EMIT_MASKWRITE(0XF8006190, 0x6FFFFEFEU, 0x00040080U),
	EMIT_MASKWRITE(0XF8006194, 0x000FFFFFU, 0x0001FD04U),
	EMIT_MASKWRITE(0XF8006204, 0xFFFFFFFFU, 0x00000000U),
	EMIT_MASKWRITE(0XF8006208, 0x000703FFU, 0x000003FFU),
	EMIT_MASKWRITE(0XF800620C, 0x000703FFU, 0x000003FFU),
	EMIT_MASKWRITE(0XF8006210, 0x000703FFU, 0x000003FFU),
	EMIT_MASKWRITE(0XF8006214, 0x000703FFU, 0x000003FFU),
	EMIT_MASKWRITE(0XF8006218, 0x000F03FFU, 0x000003FFU),
	EMIT_MASKWRITE(0XF800621C, 0x000F03FFU, 0x000003FFU),
	EMIT_MASKWRITE(0XF8006220, 0x000F03FFU, 0x000003FFU),
	EMIT_MASKWRITE(0XF8006224, 0x000F03FFU, 0x000003FFU),
	EMIT_MASKWRITE(0XF80062A8, 0x00000FF5U, 0x00000000U),
	EMIT_MASKWRITE(0XF80062AC, 0xFFFFFFFFU, 0x00000000U),
	EMIT_MASKWRITE(0XF80062B0, 0x003FFFFFU, 0x00005125U),
	EMIT_MASKWRITE(0XF80062B4, 0x0003FFFFU, 0x000012A6U),
	EMIT_MASKPOLL(0XF8000B74, 0x00002000U),
	EMIT_MASKWRITE(0XF8006000, 0x0001FFFFU, 0x00000081U),
	EMIT_MASKPOLL(0XF8006054, 0x00000007U),
	EMIT_EXIT(),
};

unsigned long ps7_mio_init_data_3_0[] = {
	EMIT_WRITE(0XF8000008, 0x0000DF0DU),
	EMIT_MASKWRITE(0XF8000B40, 0x00000FFFU, 0x00000600U),
	EMIT_MASKWRITE(0XF8000B44, 0x00000FFFU, 0x00000600U),
	EMIT_MASKWRITE(0XF8000B48, 0x00000FFFU, 0x00000672U),
	EMIT_MASKWRITE(0XF8000B4C, 0x00000FFFU, 0x00000672U),
	EMIT_MASKWRITE(0XF8000B50, 0x00000FFFU, 0x00000674U),
	EMIT_MASKWRITE(0XF8000B54, 0x00000FFFU, 0x00000674U),
	EMIT_MASKWRITE(0XF8000B58, 0x00000FFFU, 0x00000600U),
	EMIT_MASKWRITE(0XF8000B5C, 0xFFFFFFFFU, 0x0018C068U),
	EMIT_MASKWRITE(0XF8000B60, 0xFFFFFFFFU, 0x00F98068U),
	EMIT_MASKWRITE(0XF8000B64, 0xFFFFFFFFU, 0x00F98068U),
	EMIT_MASKWRITE(0XF8000B68, 0xFFFFFFFFU, 0x00F98068U),
	EMIT_MASKWRITE(0XF8000B6C, 0x00007FFFU, 0x00000260U),
	EMIT_MASKWRITE(0XF8000B70, 0x00000001U, 0x00000001U),
	EMIT_MASKWRITE(0XF8000B70, 0x00000021U, 0x00000020U),
	EMIT_MASKWRITE(0XF8000B70, 0x07FEFFFFU, 0x00000823U),
	EMIT_MASKWRITE(0XF8000700, 0x00003FFFU, 0x00000700U),
	EMIT_MASKWRITE(0XF8000704, 0x00003FFFU, 0x00000702U),
	EMIT_MASKWRITE(0XF8000708, 0x00003FFFU, 0x00000702U),
	EMIT_MASKWRITE(0XF800070C, 0x00003FFFU, 0x00000702U),
	EMIT_MASKWRITE(0XF8000710, 0x00003FFFU, 0x00000702U),
	EMIT_MASKWRITE(0XF8000714, 0x00003FFFU, 0x00000702U),
	EMIT_MASKWRITE(0XF8000718, 0x00003FFFU, 0x00000702U),
	EMIT_MASKWRITE(0XF800071C, 0x00003FFFU, 0x00000700U),
	EMIT_MASKWRITE(0XF8000720, 0x00003FFFU, 0x00000702U),
	EMIT_MASKWRITE(0XF8000724, 0x00003FFFU, 0x00000700U),
	EMIT_MASKWRITE(0XF8000728, 0x00003FFFU, 0x000007A0U),
	EMIT_MASKWRITE(0XF800072C, 0x00003FFFU, 0x000007A0U),
	EMIT_MASKWRITE(0XF8000730, 0x00003FFFU, 0x000007A0U),
	EMIT_MASKWRITE(0XF8000734, 0x00003FFFU, 0x000007A0U),
	EMIT_MASKWRITE(0XF8000738, 0x00003FFFU, 0x00000740U),
	EMIT_MASKWRITE(0XF800073C, 0x00003FFFU, 0x00000740U),
	EMIT_MASKWRITE(0XF8000740, 0x00003FFFU, 0x00000302U),
	EMIT_MASKWRITE(0XF8000744, 0x00003FFFU, 0x00000302U),
	EMIT_MASKWRITE(0XF8000748, 0x00003FFFU, 0x00000302U),
	EMIT_MASKWRITE(0XF800074C, 0x00003FFFU, 0x00000302U),
	EMIT_MASKWRITE(0XF8000750, 0x00003FFFU, 0x00000302U),
	EMIT_MASKWRITE(0XF8000754, 0x00003FFFU, 0x00000302U),
	EMIT_MASKWRITE(0XF8000758, 0x00003FFFU, 0x00000303U),
	EMIT_MASKWRITE(0XF800075C, 0x00003FFFU, 0x00000303U),
	EMIT_MASKWRITE(0XF8000760, 0x00003FFFU, 0x00000303U),
	EMIT_MASKWRITE(0XF8000764, 0x00003FFFU, 0x00000303U),
	EMIT_MASKWRITE(0XF8000768, 0x00003FFFU, 0x00000303U),
	EMIT_MASKWRITE(0XF800076C, 0x00003FFFU, 0x00000303U),
	EMIT_MASKWRITE(0XF8000770, 0x00003FFFU, 0x00000204U),
	EMIT_MASKWRITE(0XF8000774, 0x00003FFFU, 0x00000205U),
	EMIT_MASKWRITE(0XF8000778, 0x00003FFFU, 0x00000204U),
	EMIT_MASKWRITE(0XF800077C, 0x00003FFFU, 0x00000205U),
	EMIT_MASKWRITE(0XF8000780, 0x00003FFFU, 0x00000204U),
	EMIT_MASKWRITE(0XF8000784, 0x00003FFFU, 0x00000204U),
	EMIT_MASKWRITE(0XF8000788, 0x00003FFFU, 0x00000204U),
	EMIT_MASKWRITE(0XF800078C, 0x00003FFFU, 0x00000204U),
	EMIT_MASKWRITE(0XF8000790, 0x00003FFFU, 0x00000205U),
	EMIT_MASKWRITE(0XF8000794, 0x00003FFFU, 0x00000204U),
	EMIT_MASKWRITE(0XF8000798, 0x00003FFFU, 0x00000204U),
	EMIT_MASKWRITE(0XF800079C, 0x00003FFFU, 0x00000204U),
	EMIT_MASKWRITE(0XF80007A0, 0x00003FFFU, 0x00000380U),
	EMIT_MASKWRITE(0XF80007A4, 0x00003FFFU, 0x00000380U),
	EMIT_MASKWRITE(0XF80007A8, 0x00003FFFU, 0x00000380U),
	EMIT_MASKWRITE(0XF80007AC, 0x00003FFFU, 0x00000380U),
	EMIT_MASKWRITE(0XF80007B0, 0x00003FFFU, 0x00000380U),
	EMIT_MASKWRITE(0XF80007B4, 0x00003FFFU, 0x00000380U),
	EMIT_MASKWRITE(0XF80007B8, 0x00003FFFU, 0x00000321U),
	EMIT_MASKWRITE(0XF80007BC, 0x00003FFFU, 0x00001220U),
	EMIT_MASKWRITE(0XF80007C0, 0x00003FFFU, 0x00001220U),
	EMIT_MASKWRITE(0XF80007C4, 0x00003FFFU, 0x00000321U),
	EMIT_MASKWRITE(0XF80007C8, 0x00003FFFU, 0x000013E1U),
	EMIT_MASKWRITE(0XF80007CC, 0x00003FFFU, 0x000003E0U),
	EMIT_MASKWRITE(0XF80007D0, 0x00003FFFU, 0x00000380U),
	EMIT_MASKWRITE(0XF80007D4, 0x00003FFFU, 0x00000380U),
	EMIT_MASKWRITE(0XF8000830, 0x003F003FU, 0x00380037U),
	EMIT_WRITE(0XF8000004, 0x0000767BU),
	EMIT_EXIT(),
};

unsigned long ps7_peripherals_init_data_3_0[] = {
	EMIT_WRITE(0XF8000008, 0x0000DF0DU),
	EMIT_MASKWRITE(0XF8000B48, 0x00000180U, 0x00000180U),
	EMIT_MASKWRITE(0XF8000B4C, 0x00000180U, 0x00000180U),
	EMIT_MASKWRITE(0XF8000B50, 0x00000180U, 0x00000180U),
	EMIT_MASKWRITE(0XF8000B54, 0x00000180U, 0x00000180U),
	EMIT_WRITE(0XF8000004, 0x0000767BU),
	EMIT_MASKWRITE(0XE0000034, 0x000000FFU, 0x00000006U),
	EMIT_MASKWRITE(0XE0000018, 0x0000FFFFU, 0x0000007CU),
	EMIT_MASKWRITE(0XE0000000, 0x000001FFU, 0x00000017U),
	EMIT_MASKWRITE(0XE0000004, 0x000003FFU, 0x00000020U),
	EMIT_MASKWRITE(0XE000D000, 0x00080000U, 0x00080000U),
	EMIT_MASKWRITE(0XF8007000, 0x20000000U, 0x00000000U),
	EMIT_MASKDELAY(0XF8F00200, 1),
	EMIT_MASKDELAY(0XF8F00200, 1),
	EMIT_MASKDELAY(0XF8F00200, 1),
	EMIT_MASKDELAY(0XF8F00200, 1),
	EMIT_MASKDELAY(0XF8F00200, 1),
	EMIT_MASKDELAY(0XF8F00200, 1),
	EMIT_EXIT(),
};

unsigned long ps7_post_config_3_0[] = {
	EMIT_WRITE(0XF8000008, 0x0000DF0DU),
	EMIT_MASKWRITE(0XF8000900, 0x0000000FU, 0x0000000FU),
	EMIT_MASKWRITE(0XF8000240, 0xFFFFFFFFU, 0x00000000U),
	EMIT_WRITE(0XF8000004, 0x0000767BU),
	EMIT_EXIT(),
};

int ps7_post_config(void)
{
	return ps7_config(ps7_post_config_3_0);
}

int ps7_init(void)
{
	int ret;

	ret = ps7_config(ps7_mio_init_data_3_0);
	if (ret != PS7_INIT_SUCCESS)
		return ret;

	ret = ps7_config(ps7_pll_init_data_3_0);
	if (ret != PS7_INIT_SUCCESS)
		return ret;

	ret = ps7_config(ps7_clock_init_data_3_0);
	if (ret != PS7_INIT_SUCCESS)
		return ret;

	ret = ps7_config(ps7_ddr_init_data_3_0);
	if (ret != PS7_INIT_SUCCESS)
		return ret;

	ret = ps7_config(ps7_peripherals_init_data_3_0);
	if (ret != PS7_INIT_SUCCESS)
		return ret;

	return PS7_INIT_SUCCESS;
}
