/*
 * Decompiled with CFR 0.152.
 */
package org.probatron.officeotron;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.probatron.officeotron.CommentatingErrorHandler;
import org.probatron.officeotron.MceXmlFilter;
import org.probatron.officeotron.OOXMLSchemaMap;
import org.probatron.officeotron.OOXMLSchemaMapping;
import org.probatron.officeotron.OOXMLTarget;
import org.probatron.officeotron.OPCPackage;
import org.probatron.officeotron.ReportFactory;
import org.probatron.officeotron.sessionstorage.Store;
import org.probatron.officeotron.sessionstorage.ValidationSession;
import org.probatron.officeotron.utils.CachingResourceResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class OOXMLValidationSession
extends ValidationSession {
    static Logger logger = Logger.getLogger(OOXMLValidationSession.class);
    static MceXmlFilter parser;
    static Validator validator;

    public OOXMLValidationSession(UUID uUID, ReportFactory reportFactory) {
        super(uUID, reportFactory);
    }

    @Override
    public void validate() {
        OPCPackage oPCPackage = new OPCPackage(new File(Store.getDirectory(this.getUuid())));
        oPCPackage.process();
        this.checkRelationships(oPCPackage);
        if (this.errCount > 0) {
            this.getCommentary().addComment("Grand total of errors in submitted package: " + this.errCount);
        }
    }

    public void checkRelationships(OPCPackage oPCPackage) {
        OOXMLSchemaMapping oOXMLSchemaMapping;
        String string;
        OOXMLTarget oOXMLTarget;
        int n;
        logger.trace("Beginning package integrity test");
        this.getCommentary().addComment("Checking OPC Package ...");
        this.getCommentary().incIndent();
        logger.trace("Collection size: " + oPCPackage.getEntryCollection().size());
        for (n = 0; n < oPCPackage.getEntryCollection().size(); ++n) {
            oOXMLTarget = (OOXMLTarget)oPCPackage.getEntryCollection().get(n);
            string = oOXMLTarget.getMimeType();
            logger.trace("Testing entry of MIME type: " + string);
            oOXMLSchemaMapping = OOXMLSchemaMap.getMappingForContentType(string);
            if (oOXMLSchemaMapping == null) {
                logger.info("No mapping found for entry");
                continue;
            }
            if (oOXMLTarget.getType().equals(oOXMLSchemaMapping.getRelType())) continue;
            logger.debug("Relationship type mismatch");
            ++this.errCount;
            this.getCommentary().addComment("ERROR", "Entry with MIME type \"" + string + "\" has unrecognized relationship type \"" + oOXMLTarget.getType() + "\" (see ISO/IEC 29500-1:2008, Clause " + oOXMLSchemaMapping.getClause() + ")");
        }
        if (this.errCount > 0) {
            this.getCommentary().addComment("ERROR", "" + this.errCount + " problem" + (this.errCount > 1 ? "s" : "") + " found with OPC package");
        } else {
            this.getCommentary().addComment("No problems found with OPC package");
        }
        this.getCommentary().decIndent();
        this.getCommentary().addComment("Validating " + oPCPackage.getEntryCollection().size() + " parts ...");
        for (n = 0; n < oPCPackage.getEntryCollection().size(); ++n) {
            oOXMLTarget = (OOXMLTarget)oPCPackage.getEntryCollection().get(n);
            string = oOXMLTarget.getMimeType();
            logger.debug("Validating entry of MIME type: " + string);
            oOXMLSchemaMapping = OOXMLSchemaMap.getMappingForContentType(string);
            if (oOXMLSchemaMapping == null) {
                logger.debug("Trying to find MIME type for extension " + oOXMLTarget.getExtension());
                string = (String)oPCPackage.dtm.get(oOXMLTarget.getExtension());
                oOXMLSchemaMapping = OOXMLSchemaMap.getMappingForContentType(string);
            }
            if (oOXMLSchemaMapping == null) {
                this.getCommentary().addComment("Cannot determine schema for Part named (\"<![CDATA[" + oOXMLTarget.getTargetAsPartName() + "]]>\")");
                logger.debug("Cannot determine schema for " + oOXMLTarget);
                continue;
            }
            this.validateTarget(oOXMLTarget, oOXMLSchemaMapping);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validateTarget(OOXMLTarget oOXMLTarget, OOXMLSchemaMapping oOXMLSchemaMapping) {
        Class<OOXMLValidationSession> clazz = OOXMLValidationSession.class;
        synchronized (OOXMLValidationSession.class) {
            String string = oOXMLSchemaMapping.getSchemaName();
            this.getCommentary().addComment("Validating part \"" + oOXMLTarget.getTargetAsPartName() + "\" using schema \"" + oOXMLSchemaMapping.getSchemaName() + "\" ...");
            this.getCommentary().incIndent();
            if (oOXMLSchemaMapping.getContentType().equals("application/vnd.openxmlformats-officedocument.vmlDrawing")) {
                logger.debug("VML found");
                this.getCommentary().addComment("WARN", "Warning: deprecated content (VML) detected");
            }
            if (string == null || string.length() == 0) {
                this.getCommentary().addComment("No schema known to validate content of type: " + oOXMLSchemaMapping.getContentType());
            } else {
                try {
                    CommentatingErrorHandler commentatingErrorHandler = new CommentatingErrorHandler(this.getCommentary(), oOXMLTarget.getName());
                    validator.setErrorHandler(commentatingErrorHandler);
                    String string2 = this.getUrlForEntry(oOXMLTarget.getTargetAsPartName()).toString();
                    logger.debug("Validating: " + string2 + " using schema " + oOXMLSchemaMapping.getSchemaName());
                    parser.setVMLStream(oOXMLSchemaMapping.getSchemaName().contains("vml"));
                    validator.validate(new SAXSource(parser, new InputSource(string2)));
                    if (commentatingErrorHandler.getInstanceErrCount() > 0) {
                        this.getCommentary().addComment("\"" + oOXMLTarget.getTargetAsPartName() + "\" contains " + commentatingErrorHandler.getInstanceErrCount() + " validity error" + (commentatingErrorHandler.getInstanceErrCount() > 1 ? "s" : ""));
                        this.errCount += commentatingErrorHandler.getInstanceErrCount();
                    } else {
                        this.getCommentary().addComment("\"" + oOXMLTarget.getTargetAsPartName() + "\" is schema-valid");
                    }
                    if (commentatingErrorHandler.getInstanceErrCount() > 10) {
                        this.getCommentary().addComment("(<i>" + (commentatingErrorHandler.getInstanceErrCount() - 10) + " error(s) omitted for the sake of brevity</i>)");
                    }
                }
                catch (SAXException sAXException) {
                    logger.error(sAXException + " " + sAXException.getMessage());
                }
                catch (IOException iOException) {
                    logger.error(iOException + " " + iOException.getMessage());
                }
            }
            this.getCommentary().decIndent();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    static {
        String string = System.getProperty("property://probatron.org/officeotron-log-level");
        string = string == null ? "ERROR" : string;
        Properties properties = new Properties();
        properties.setProperty("log4j.rootCategory", string + ", A1");
        properties.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        properties.setProperty("log4j.appender.A1.target", "System.err");
        properties.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        properties.setProperty("log4j.appender.A1.layout.ConversionPattern", "%c %p - %m%n");
        PropertyConfigurator.configure(properties);
        try {
            System.setProperty("org.apache.xerces.xni.parser.XMLParserConfiguration", "org.apache.xerces.parsers.XMLGrammarCachingConfiguration");
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            parser = new MceXmlFilter(xMLReader);
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<StreamSource> arrayList2 = new ArrayList<StreamSource>();
            Set<String> set = OOXMLSchemaMap.getContentTypes();
            for (String object2 : set) {
                Object object;
                OOXMLSchemaMapping oOXMLSchemaMapping = OOXMLSchemaMap.getMappingForContentType(object2);
                if (oOXMLSchemaMapping.getSchemaName().isEmpty() || arrayList.contains(oOXMLSchemaMapping.getSchemaName())) continue;
                arrayList.add(oOXMLSchemaMapping.getSchemaName());
                URL uRL = ClassLoader.getSystemResource("schema/" + oOXMLSchemaMapping.getSchemaName());
                if (uRL != null && !uRL.toString().isEmpty()) {
                    object = uRL.toString();
                    arrayList2.add(new StreamSource((String)object));
                    logger.trace("Loading schema from: " + (String)object);
                    continue;
                }
                if (oOXMLSchemaMapping.getSchemaName().isEmpty()) continue;
                object = new URL(oOXMLSchemaMapping.getSchemaName());
                try {
                    ((URL)object).openStream();
                    arrayList2.add(new StreamSource(oOXMLSchemaMapping.getSchemaName()));
                }
                catch (Exception exception) {}
            }
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setResourceResolver(new CachingResourceResolver());
            Schema schema = schemaFactory.newSchema(arrayList2.toArray(new Source[arrayList2.size()]));
            validator = schema.newValidator();
        }
        catch (Exception exception) {
            logger.error("Couldn't create parser", exception);
        }
    }
}

