/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.construction;

import java.util.Vector;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.AngleConstructor;
import rene.zirkel.constructors.AreaConstructor;
import rene.zirkel.constructors.CircleConstructor;
import rene.zirkel.constructors.ExpressionConstructor;
import rene.zirkel.constructors.FunctionConstructor;
import rene.zirkel.constructors.IntersectionConstructor;
import rene.zirkel.constructors.LineConstructor;
import rene.zirkel.constructors.MidpointConstructor;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.constructors.ParallelConstructor;
import rene.zirkel.constructors.PlumbConstructor;
import rene.zirkel.constructors.PointConstructor;
import rene.zirkel.constructors.QuadricConstructor;
import rene.zirkel.constructors.RayConstructor;
import rene.zirkel.constructors.SegmentConstructor;
import rene.zirkel.macro.Macro;
import rene.zirkel.macro.MacroRunner;
import rene.zirkel.objects.AngleObject;
import rene.zirkel.objects.CircleObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.ExpressionObject;
import rene.zirkel.objects.FixedAngleObject;
import rene.zirkel.objects.FixedCircleObject;
import rene.zirkel.objects.IntersectionObject;
import rene.zirkel.objects.LineObject;
import rene.zirkel.objects.PlumbObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.SegmentObject;
import rene.zirkel.objects.TwoPointLineObject;

public class Interpreter {
    Construction C;
    MacroRunner MR = new MacroRunner();
    static ObjectConstructor[] OCs = new ObjectConstructor[]{new PointConstructor(), new SegmentConstructor(), new LineConstructor(), new RayConstructor(), new CircleConstructor(), new IntersectionConstructor(), new ParallelConstructor(), new PlumbConstructor(), new MidpointConstructor(), new AngleConstructor(), new AreaConstructor(), new QuadricConstructor(), new ExpressionConstructor(), new FunctionConstructor()};
    public static String[] ONs = new String[]{"point", "segment", "line", "ray", "circle", "intersection", "parallel", "plumb", "midpoint", "angle", "area", "quadric", "expression", "function"};

    public Interpreter(Construction construction) {
        this.C = construction;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void interpret(ZirkelCanvas zirkelCanvas, String string, String string2) throws ConstructionException {
        int n;
        int n2;
        Object object;
        Object object2;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Vector vector = this.C.V;
        int n3 = vector.size();
        int n4 = Interpreter.startTest("parameter", string);
        if (n4 >= 0) {
            bl = true;
            string = string.substring(n4).trim();
        } else {
            if (string.toLowerCase().equals(Zirkel.name("showall")) || string.toLowerCase().equals("showall")) {
                this.C.ShowAll = true;
                return;
            }
            if (string.toLowerCase().equals(Zirkel.name("invisible")) || string.toLowerCase().equals("invisible")) {
                this.C.SuperHide = true;
                return;
            }
            n4 = Interpreter.startTest("target", string);
            if (n4 >= 0) {
                bl2 = true;
                string = string.substring(n4).trim();
                object2 = this.C.find(string);
                this.C.determineConstructables();
                if (object2 != null && ((ConstructionObject)object2).isFlag()) {
                    ((ConstructionObject)object2).setTarget(true);
                    this.C.addTarget((ConstructionObject)object2);
                    return;
                }
                bl2 = true;
            } else {
                n4 = Interpreter.startTest("prompt", string);
                if (n4 >= 0) {
                    bl3 = true;
                    if (this.C.find(string = string.substring(n4).trim()) != null) {
                        this.C.PromptFor.addElement(string);
                        return;
                    }
                }
            }
        }
        object2 = "";
        String string3 = "";
        String[] stringArray = new String[16];
        int n5 = 0;
        int n6 = string.indexOf(61);
        if (n6 >= 0) {
            object2 = string.substring(0, n6).trim();
            string = string.substring(n6 + 1).trim();
        }
        int n7 = 0;
        if (string.startsWith("\"")) {
            n7 = string.indexOf("\"", 1);
        }
        if (n7 < 0) {
            throw new ConstructionException("exception.brackets");
        }
        n6 = string.indexOf(40, n7);
        if (n6 >= 0) {
            string3 = string.substring(0, n6).trim();
            if (string3.startsWith("\"") && string3.endsWith("\"") && string3.length() > 1) {
                string3 = string3.substring(1, string3.length() - 1);
            }
            if (!(string = string.substring(n6 + 1).trim()).endsWith(")")) {
                throw new ConstructionException("exception.brackets");
            }
            object = string.substring(0, string.length() - 1).toCharArray();
            n2 = 0;
            for (n = 0; n < ((Object)object).length && n5 < stringArray.length; ++n) {
                int n8 = n;
                while (n < ((Object)object).length && (n2 > 0 || object[n] != 44)) {
                    if (object[n] == 34) {
                        ++n;
                        while (n < ((Object)object).length && object[n] != 34) {
                            ++n;
                        }
                        if (n >= ((Object)object).length) {
                            throw new ConstructionException(Zirkel.name("exception.quotes"));
                        }
                        ++n;
                        continue;
                    }
                    if (object[n] == 40) {
                        ++n2;
                        ++n;
                        continue;
                    }
                    if (object[n] == 41) {
                        if (n2 <= 0) throw new ConstructionException(Zirkel.name("exception.brackets"));
                        --n2;
                        ++n;
                        continue;
                    }
                    ++n;
                }
                stringArray[n5++] = new String((char[])object, n8, n - n8).trim();
            }
        } else {
            string3 = string;
        }
        object = string3;
        if (n5 == 3 && Interpreter.ptest((String)object, "window")) {
            try {
                double d2 = new Double(stringArray[0]);
                double d3 = new Double(stringArray[1]);
                double d4 = new Double(stringArray[2]);
                this.C.setXYW(d2, d3, d4);
                zirkelCanvas.recompute();
                return;
            }
            catch (Exception exception) {
                throw new ConstructionException(Zirkel.name("exception.value"));
            }
        }
        if ((n5 == 1 || n5 == 2) && Interpreter.ptest((String)object, "color")) {
            n = 0;
            for (n = 0; n < ZirkelFrame.ColorStrings.length && !Interpreter.test(stringArray[0], "colors", ZirkelFrame.ColorStrings[n]); ++n) {
            }
            if (n >= ZirkelFrame.ColorStrings.length) throw new ConstructionException(Zirkel.name("exception.color"));
            if (n5 == 2) {
                ConstructionObject constructionObject = this.C.find(stringArray[1]);
                if (constructionObject == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                constructionObject.setColor(n);
                return;
            } else {
                this.C.DefaultColor = n;
            }
            return;
        }
        if ((n5 == 1 || n5 == 2) && Interpreter.ptest((String)object, "thickness")) {
            n = 0;
            for (n = 0; n < ZirkelFrame.ColorTypes.length && !Interpreter.test(stringArray[0], "color.type", ZirkelFrame.ColorTypes[n]); ++n) {
            }
            if (n >= ZirkelFrame.ColorTypes.length) throw new ConstructionException(Zirkel.name("exception.colortype"));
            if (n5 == 2) {
                ConstructionObject constructionObject = this.C.find(stringArray[1]);
                if (constructionObject == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                constructionObject.setColorType(n);
                return;
            } else {
                this.C.DefaultColorType = n;
            }
            return;
        }
        if ((n5 == 1 || n5 == 2) && Interpreter.ptest((String)object, "type")) {
            n = 0;
            for (n = 0; n < ZirkelFrame.PointTypes.length && !Interpreter.test(stringArray[0], "point.type", ZirkelFrame.PointTypes[n]); ++n) {
            }
            if (n >= ZirkelFrame.PointTypes.length) throw new ConstructionException(Zirkel.name("exception.type"));
            if (n5 == 2) {
                ConstructionObject constructionObject = this.C.find(stringArray[1]);
                if (constructionObject == null || !(constructionObject instanceof PointObject)) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                ((PointObject)constructionObject).setType(n);
                return;
            } else {
                this.C.DefaultType = n;
            }
            return;
        }
        if ((n5 == 1 || n5 == 2) && Interpreter.ptest((String)object, "partial")) {
            if (n5 == 1 && !Interpreter.truecheck(stringArray[0])) {
                ConstructionObject constructionObject = this.C.find(stringArray[0]);
                if (constructionObject == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                if (constructionObject instanceof PrimitiveCircleObject) {
                    ((PrimitiveCircleObject)constructionObject).setPartial(true);
                }
                if (!(constructionObject instanceof LineObject)) return;
                ((LineObject)constructionObject).setPartial(true);
                return;
            }
            n = Interpreter.truetest(stringArray[0]) ? 1 : 0;
            if (n5 == 2) {
                ConstructionObject constructionObject = this.C.find(stringArray[1]);
                if (constructionObject == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                if (constructionObject instanceof PrimitiveCircleObject) {
                    ((PrimitiveCircleObject)constructionObject).setPartial(n != 0);
                }
                if (!(constructionObject instanceof LineObject)) return;
                ((LineObject)constructionObject).setPartial(n != 0);
                return;
            } else {
                this.C.Partial = n;
                this.C.PartialLines = n;
            }
            return;
        }
        if ((n5 == 1 || n5 == 2) && Interpreter.ptest((String)object, "hide")) {
            if (n5 == 1 && !Interpreter.truecheck(stringArray[0])) {
                ConstructionObject constructionObject = this.C.find(stringArray[0]);
                if (constructionObject == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                constructionObject.setHidden(true);
                return;
            }
            n = Interpreter.truetest(stringArray[0]) ? 1 : 0;
            if (n5 == 2) {
                ConstructionObject constructionObject = this.C.find(stringArray[1]);
                if (constructionObject == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                constructionObject.setHidden(n != 0);
                return;
            } else {
                this.C.Hidden = n;
            }
            return;
        }
        if (n5 == 2 && Interpreter.ptest((String)object, "invisible")) {
            if (n5 == 1 && !Interpreter.truecheck(stringArray[0])) {
                ConstructionObject constructionObject = this.C.find(stringArray[0]);
                if (constructionObject == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                constructionObject.setSuperHidden(true);
                return;
            }
            n = Interpreter.truetest(stringArray[0]) ? 1 : 0;
            if (n5 != 2) throw new ConstructionException(Zirkel.name("exception.notfound"));
            ConstructionObject constructionObject = this.C.find(stringArray[1]);
            if (constructionObject == null) {
                throw new ConstructionException(Zirkel.name("exception.notfound"));
            }
            constructionObject.setSuperHidden(n != 0);
            return;
        }
        if (n5 >= 1 && Interpreter.ptest((String)object, "back")) {
            if (n5 == 1) {
                ConstructionObject constructionObject = this.C.find(stringArray[0]);
                if (constructionObject == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                constructionObject.setBack(true);
                return;
            }
            n = Interpreter.truetest(stringArray[0]) ? 1 : 0;
            ConstructionObject constructionObject = this.C.find(stringArray[1]);
            if (constructionObject == null) {
                throw new ConstructionException(Zirkel.name("exception.notfound"));
            }
            constructionObject.setBack(n != 0);
            return;
        }
        if (n5 >= 1 && Interpreter.ptest((String)object, "acute")) {
            if (n5 == 1 && !Interpreter.truecheck(stringArray[0])) {
                ConstructionObject constructionObject = this.C.find(stringArray[0]);
                if (constructionObject == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                constructionObject.setObtuse(false);
                return;
            }
            n = Interpreter.truetest(stringArray[0]) ? 1 : 0;
            if (n5 == 2) {
                ConstructionObject constructionObject = this.C.find(stringArray[1]);
                if (constructionObject == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                constructionObject.setObtuse(n == 0);
                return;
            } else {
                this.C.Obtuse = n == 0;
            }
            return;
        }
        if (n5 >= 1 && Interpreter.ptest((String)object, "obtuse")) {
            if (n5 == 1 && !Interpreter.truecheck(stringArray[0])) {
                ConstructionObject constructionObject = this.C.find(stringArray[0]);
                if (constructionObject == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                constructionObject.setObtuse(false);
                return;
            }
            n = Interpreter.truetest(stringArray[0]) ? 1 : 0;
            if (n5 == 2) {
                ConstructionObject constructionObject = this.C.find(stringArray[1]);
                if (constructionObject == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                constructionObject.setObtuse(n != 0);
                return;
            } else {
                this.C.Obtuse = n;
            }
            return;
        }
        if (n5 >= 1 && Interpreter.ptest((String)object, "solid")) {
            if (n5 == 1 && !Interpreter.truecheck(stringArray[0])) {
                ConstructionObject constructionObject = this.C.find(stringArray[0]);
                if (constructionObject == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                constructionObject.setSolid(false);
                return;
            }
            n = Interpreter.truetest(stringArray[0]) ? 1 : 0;
            if (n5 == 2) {
                ConstructionObject constructionObject = this.C.find(stringArray[1]);
                if (constructionObject == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                constructionObject.setSolid(n != 0);
                return;
            } else {
                this.C.Solid = n;
            }
            return;
        }
        if (n5 == 3 && Interpreter.ptest((String)object, "restrict")) {
            try {
                PrimitiveCircleObject primitiveCircleObject = (PrimitiveCircleObject)this.C.find(stringArray[0]);
                if (primitiveCircleObject.setRange(stringArray[1], stringArray[2])) return;
                throw new Exception("");
            }
            catch (Exception exception) {
                throw new ConstructionException(Zirkel.name("exception.notfound"));
            }
        }
        if (n5 >= 1 && Interpreter.ptest((String)object, "fill")) {
            if (n5 == 1) {
                ConstructionObject constructionObject = this.C.find(stringArray[0]);
                if (constructionObject == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                constructionObject.setFilled(true);
                constructionObject.setBack(true);
                return;
            }
            n = Interpreter.truetest(stringArray[0]) ? 1 : 0;
            ConstructionObject constructionObject = this.C.find(stringArray[1]);
            if (constructionObject == null) {
                throw new ConstructionException(Zirkel.name("exception.notfound"));
            }
            constructionObject.setFilled(n != 0);
            constructionObject.setBack(n != 0);
            return;
        }
        if (n5 >= 1 && Interpreter.ptest((String)object, "valid")) {
            if (n5 == 1) {
                ConstructionObject constructionObject = this.C.find(stringArray[0]);
                if (constructionObject == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                if (constructionObject instanceof PlumbObject) {
                    ((PlumbObject)constructionObject).setRestricted(false);
                    return;
                } else {
                    if (!(constructionObject instanceof IntersectionObject)) return;
                    ((IntersectionObject)constructionObject).setRestricted(false);
                }
                return;
            }
            n = Interpreter.truetest(stringArray[0]) ? 1 : 0;
            ConstructionObject constructionObject = this.C.find(stringArray[1]);
            if (constructionObject == null) {
                throw new ConstructionException(Zirkel.name("exception.notfound"));
            }
            if (constructionObject instanceof PlumbObject) {
                ((PlumbObject)constructionObject).setRestricted(false);
                return;
            } else {
                if (!(constructionObject instanceof IntersectionObject)) return;
                ((IntersectionObject)constructionObject).setRestricted(false);
            }
            return;
        }
        if (n5 >= 1 && (Interpreter.ptest((String)object, "rename") || Interpreter.ptest((String)object, "name"))) {
            if (n5 == 1 && !Interpreter.truecheck(stringArray[0])) {
                ConstructionObject constructionObject = this.C.find(stringArray[0]);
                if (constructionObject == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                constructionObject.setShowName(true);
                return;
            }
            ConstructionObject constructionObject = this.C.find(stringArray[0]);
            if (constructionObject == null) {
                n2 = Interpreter.truetest(stringArray[0]) ? 1 : 0;
                if (n5 == 2) {
                    constructionObject = this.C.find(stringArray[1]);
                    if (constructionObject == null) {
                        throw new ConstructionException(Zirkel.name("exception.notfound"));
                    }
                    constructionObject.setShowName(Interpreter.truetest(stringArray[0]));
                    return;
                } else {
                    this.C.ShowNames = n2;
                }
                return;
            } else {
                if (stringArray[1].equals("")) return;
                constructionObject.setName(stringArray[1]);
            }
            return;
        }
        if (n5 == 2 && Interpreter.ptest((String)object, "away")) {
            ConstructionObject constructionObject = this.C.find(stringArray[0]);
            ConstructionObject constructionObject2 = this.C.find(stringArray[1]);
            if (!(constructionObject instanceof IntersectionObject) || !(constructionObject2 instanceof PointObject)) {
                throw new ConstructionException(Zirkel.name("exception.parameter"));
            }
            ((IntersectionObject)constructionObject).setAway(constructionObject2.getName());
            return;
        }
        if (n5 == 2 && Interpreter.ptest((String)object, "close")) {
            ConstructionObject constructionObject = this.C.find(stringArray[0]);
            ConstructionObject constructionObject3 = this.C.find(stringArray[1]);
            if (!(constructionObject instanceof IntersectionObject) || !(constructionObject3 instanceof PointObject)) {
                throw new ConstructionException(Zirkel.name("exception.parameter"));
            }
            ((IntersectionObject)constructionObject).setAway(constructionObject3.getName(), false);
            return;
        }
        if (n5 >= 1 && Interpreter.ptest((String)object, "value")) {
            if (n5 == 1 && !Interpreter.truecheck(stringArray[0])) {
                ConstructionObject constructionObject = this.C.find(stringArray[0]);
                if (constructionObject == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                constructionObject.setShowValue(true);
                return;
            }
            ConstructionObject constructionObject = this.C.find(stringArray[0]);
            if (constructionObject == null) {
                try {
                    Interpreter.truetest(stringArray[0]);
                }
                catch (Exception exception) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                if (n5 == 2) {
                    constructionObject = this.C.find(stringArray[1]);
                    if (constructionObject == null) {
                        throw new ConstructionException(Zirkel.name("exception.notfound"));
                    }
                    constructionObject.setShowValue(Interpreter.truetest(stringArray[0]));
                    return;
                } else {
                    this.C.ShowValues = true;
                }
                return;
            }
            if (n5 == 2) {
                if (constructionObject instanceof SegmentObject) {
                    SegmentObject segmentObject = (SegmentObject)constructionObject;
                    if (!segmentObject.canFix()) {
                        throw new ConstructionException(Zirkel.name("exception.canfix"));
                    }
                    segmentObject.setFixed(true, stringArray[1]);
                    segmentObject.validate();
                    return;
                } else if (constructionObject instanceof CircleObject) {
                    CircleObject circleObject = (CircleObject)constructionObject;
                    if (!circleObject.canFix()) {
                        throw new ConstructionException(Zirkel.name("exception.canfix"));
                    }
                    circleObject.setFixed(true, stringArray[1]);
                    circleObject.validate();
                    return;
                } else if (constructionObject instanceof FixedCircleObject) {
                    FixedCircleObject fixedCircleObject = (FixedCircleObject)constructionObject;
                    fixedCircleObject.setFixed(stringArray[1]);
                    fixedCircleObject.validate();
                    return;
                } else if (constructionObject instanceof AngleObject) {
                    AngleObject angleObject = (AngleObject)constructionObject;
                    if (!angleObject.canFix()) {
                        throw new ConstructionException(Zirkel.name("exception.canfix"));
                    }
                    angleObject.setFixed(stringArray[1]);
                    angleObject.validate();
                    return;
                } else if (constructionObject instanceof FixedAngleObject) {
                    FixedAngleObject fixedAngleObject = (FixedAngleObject)constructionObject;
                    fixedAngleObject.setFixed(stringArray[1]);
                    fixedAngleObject.validate();
                    return;
                } else {
                    if (!(constructionObject instanceof ExpressionObject)) throw new ConstructionException(Zirkel.name("exception.parameter"));
                    ExpressionObject expressionObject = (ExpressionObject)constructionObject;
                    expressionObject.setFixed(stringArray[1]);
                    expressionObject.validate();
                }
                return;
            } else {
                if (n5 != 3) throw new ConstructionException(Zirkel.name("exception.parameter"));
                if (!(constructionObject instanceof PointObject)) throw new ConstructionException(Zirkel.name("exception.parameter"));
                PointObject pointObject = (PointObject)constructionObject;
                if (!pointObject.moveablePoint()) {
                    throw new ConstructionException(Zirkel.name("exception.canfix"));
                }
                pointObject.setFixed(stringArray[1], stringArray[2]);
                pointObject.validate();
            }
            return;
        }
        n = Interpreter.findFunction(string3, zirkelCanvas);
        if (n >= 0) {
            for (n2 = 0; n2 < n5; ++n2) {
                stringArray[n2] = this.extend(stringArray[n2]);
            }
            OCs[n].construct(this.C, (String)object2, stringArray, n5);
            if (bl) {
                if (n3 >= vector.size()) {
                    throw new ConstructionException(Zirkel.name("exception.macroparameter"));
                }
                ConstructionObject constructionObject = this.C.last();
                constructionObject.setMainParameter();
                if (!constructionObject.isMainParameter()) throw new ConstructionException(Zirkel.name("exception.macroparameter"));
                this.C.addParameter(constructionObject);
                this.C.Prompts.addElement(string2);
                return;
            } else if (bl2) {
                if (n3 + 1 != vector.size()) {
                    throw new ConstructionException(Zirkel.name("exception.macrotarget"));
                }
                ConstructionObject constructionObject = this.C.last();
                constructionObject.setTarget(true);
                this.C.addTarget(constructionObject);
                return;
            } else {
                if (!bl3) return;
                ConstructionObject constructionObject = this.C.last();
                this.C.PromptFor.addElement(constructionObject.getName());
            }
            return;
        }
        Macro macro = zirkelCanvas.chooseMacro(string3);
        if (macro == null) {
            throw new ConstructionException(Zirkel.name("exception.function"));
        }
        this.MR.setMacro(macro, zirkelCanvas);
        this.MR.run(zirkelCanvas, this.C, (String)object2, stringArray, n5);
        if (bl2) {
            ConstructionObject constructionObject = this.C.find((String)object2);
            if (constructionObject == null) {
                throw new ConstructionException(Zirkel.name("exception.macrotarget"));
            }
            constructionObject.setTarget(true);
            this.C.addTarget(constructionObject);
            return;
        } else {
            ConstructionObject constructionObject;
            if (!bl3 || (constructionObject = this.C.find((String)object2)) == null) return;
            this.C.PromptFor.addElement(constructionObject.getName());
        }
    }

    public void interpret(ZirkelCanvas zirkelCanvas, String string) throws ConstructionException {
        this.interpret(zirkelCanvas, string, "");
    }

    public static boolean truetest(String string) throws ConstructionException {
        if ((string = string.toLowerCase()).equals("true") || string.equals(Zirkel.name("true"))) {
            return true;
        }
        if (string.equals("false") || string.equals(Zirkel.name("false"))) {
            return false;
        }
        throw new ConstructionException(Zirkel.name("exception.boolean"));
    }

    public static boolean truecheck(String string) {
        if ((string = string.toLowerCase()).equals("true") || string.equals(Zirkel.name("true"))) {
            return true;
        }
        return string.equals("false") || string.equals(Zirkel.name("false"));
    }

    public static boolean test(String string, String string2, String string3) {
        return string.equalsIgnoreCase(Zirkel.name(string2 + "." + string3, "")) || string.equals(Zirkel.name(string2 + ".short." + string3, "")) || string.equals(Zirkel.name(string2 + "." + string3 + ".short", "")) || string.equalsIgnoreCase(string3);
    }

    public static int startTest(String string, String string2) {
        int n = Interpreter.startTest0(Zirkel.name(string, string).toLowerCase(), string2.toLowerCase());
        if (n > 0) {
            return n;
        }
        n = Interpreter.startTest0(Zirkel.name(string + ".short", string), string2);
        if (n > 0) {
            return n;
        }
        return Interpreter.startTest0(string, string2.toLowerCase());
    }

    public static int startTest0(String string, String string2) {
        if (string2.startsWith(string + " ")) {
            return string.length() + 1;
        }
        return -1;
    }

    public static boolean ptest(String string, String string2) {
        return Interpreter.test(string, "function", string2);
    }

    public static boolean nametest(String string, String string2) {
        return Interpreter.test(string, "name", string2);
    }

    public String extend(String string) {
        ConstructionObject constructionObject;
        if (string.startsWith("c(") && string.endsWith(")")) {
            ConstructionObject constructionObject2 = this.C.find(string = string.substring(2, string.length() - 1));
            if (constructionObject2 instanceof PrimitiveCircleObject) {
                return ((PrimitiveCircleObject)constructionObject2).getP1().getName();
            }
        } else if (string.startsWith("a(") && string.endsWith(")")) {
            ConstructionObject constructionObject3 = this.C.find(string = string.substring(2, string.length() - 1));
            if (constructionObject3 instanceof TwoPointLineObject) {
                return ((TwoPointLineObject)constructionObject3).getP1().getName();
            }
        } else if (string.startsWith("b(") && string.endsWith(")") && (constructionObject = this.C.find(string = string.substring(2, string.length() - 1))) instanceof TwoPointLineObject) {
            return ((TwoPointLineObject)constructionObject).getP2().getName();
        }
        return string;
    }

    public static int findFunction(String string, ZirkelCanvas zirkelCanvas) {
        for (int i = 0; i < OCs.length; ++i) {
            if (!Interpreter.nametest(string, OCs[i].getTag()) || !zirkelCanvas.enabled(ONs[i])) continue;
            return i;
        }
        return -1;
    }
}

