/*********************************************************************/
// webdar - a web server and interface program to libdar
// Copyright (C) 2013-2025 Denis Corbin
//
// This file is part of Webdar
//
//  Webdar is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  Webdar is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with Webdar.  If not, see <http://www.gnu.org/licenses/>
//
//----
//  to contact the author: dar.linux@free.fr
/*********************************************************************/

    // C system header files
#include "my_config.h"
extern "C"
{

}

    // C++ system header files


    // webdar headers



    //
#include "html_double_button.hpp"

using namespace std;

const string html_double_button::event_one = "evenement_un";
const string html_double_button::event_two = "evenement_deux";

html_double_button::html_double_button(const string & label, const string & x_event_name):
    one(label, event_one),
    two(label, event_two),
    my_event_name(x_event_name)
{
    adopt(&one);
    adopt(&two);
    swap(true);

    register_name(my_event_name);
    one.record_actor_on_event(this, event_one);
    two.record_actor_on_event(this, event_two);
}

void html_double_button::on_event(const string & event_name)
{
    if(event_name == event_one) // event generated by one
    {
	if(!one.get_visible())
	    throw WEBDAR_BUG; // should not occur!
	swap(false); // making two visible and one hidden
    }
    else if(event_name == event_two) // event generated by two
    {
	if(!two.get_visible())
	    throw WEBDAR_BUG; // should not occur!
	swap(true); // making one visible and two hidden
    }
    else
	throw WEBDAR_BUG;

    act(my_event_name); // propagate the event
}

string html_double_button::inherited_get_body_part(const chemin & path,
						   const request & req)
{
    return get_body_part_from_all_children(path, req);
}

void html_double_button::css_classes_have_changed()
{
    css_class_group myset = get_css_class_group();

    one.clear_css_classes();
    two.clear_css_classes();
    one.add_css_class(myset);
    two.add_css_class(myset);
}

void html_double_button::swap(bool show_one)
{
    one.set_visible(show_one);
    two.set_visible(!show_one);
}
