# Summary

- [Introduction](./introduction.md)
- [Using the Wasmtime CLI](./cli.md)
  - [Installation](./cli-install.md)
  - [CLI Options](./cli-options.md)
  - [CLI Logging](./cli-logging.md)
  - [Cache Configuration](./cli-cache.md)
- [Using the Wasmtime API](./lang.md)
  - [Rust](./lang-rust.md)
    - [Hello, world!](./examples-rust-hello-world.md)
    - [Calculating the GCD](./examples-rust-gcd.md)
    - [Using Linear Memory](./examples-rust-memory.md)
    - [WASI](./examples-rust-wasi.md)
    - [Linking Modules](./examples-rust-linking.md)
    - [Debugging](./examples-rust-debugging.md)
    - [Core Dumps](./examples-rust-core-dumps.md)
    - [Using Multi-Value](./examples-rust-multi-value.md)
  - [C](./lang-c.md)
    - [Hello, World!](./examples-c-hello-world.md)
    - [Calculating the GCD](./examples-c-gcd.md)
    - [Using Linear Memory](./examples-c-memory.md)
    - [WASI](./examples-c-wasi.md)
    - [Linking Modules](./examples-c-linking.md)
    - [Debugging](./examples-c-debugging.md)
    - [Using Multi-Value](./examples-c-multi-value.md)
  - [Python](./lang-python.md)
  - [.NET](./lang-dotnet.md)
  - [Go](./lang-go.md)
  - [Bash](./lang-bash.md)
  - [Ruby](./lang-ruby.md)
  - [Elixir](./lang-elixir.md)
- [Further Examples](./examples.md)
  - [Debugging WebAssembly](./examples-debugging.md)
    - [Debugging with `gdb` and `lldb`](./examples-debugging-native-debugger.md)
    - [Debugging with Core Dumps](./examples-debugging-core-dumps.md)
  - [Profiling WebAssembly](./examples-profiling.md)
    - [Profiling with Perf](./examples-profiling-perf.md)
    - [Profiling with VTune](./examples-profiling-vtune.md)
    - [Profiling with samply](./examples-profiling-samply.md)
    - [Cross-platform Profiling](./examples-profiling-guest.md)
  - [Checking Guests' Memory Accesses](./wmemcheck.md)
  - [Building a minimal embedding](./examples-minimal.md)
- [Stability](stability.md)
  - [Release Process](./stability-release.md)
  - [Tiers of support](./stability-tiers.md)
  - [Platform Support](./stability-platform-support.md)
  - [Wasm Proposals](./stability-wasm-proposals.md)
- [Security](security.md)
  - [Disclosure Policy](./security-disclosure.md)
  - [What is considered a security bug?](./security-what-is-considered-a-security-vulnerability.md)
  - [Vulnerability runbook](./security-vulnerability-runbook.md)
- [Contributing](contributing.md)
  - [Architecture](./contributing-architecture.md)
  - [Building](./contributing-building.md)
  - [Testing](./contributing-testing.md)
  - [Fuzzing](./contributing-fuzzing.md)
  - [CI](./contributing-ci.md)
  - [Reducing Test Cases](./contributing-reducing-test-cases.md)
  - [Cross Compiling](./contributing-cross-compiling.md)
  - [Coding Guidelines](./contributing-coding-guidelines.md)
  - [Development Process](./contributing-development-process.md)
  - [Implementing Wasm Proposals](./contributing-implementing-wasm-proposals.md)
  - [Maintainer Guidelines](./contributing-maintainer-guidelines.md)
    - [Code Review](./contributing-code-review.md)
    - [Release Process](./contributing-release-process.md)
  - [Governance](./contributing-governance.md)
  - [Code of Conduct](./contributing-coc.md)
