mod test_utils;

use flexi_logger::{DeferredNow, Logger};
use log::*;

#[test]
#[should_panic(expected = "offset is already initialized not to enforce UTC")]
fn test_force_utc_1_panic() {
    let _ = Logger::try_with_str("info")
        .unwrap()
        .format_for_stderr(flexi_logger::detailed_format)
        .start()
        .unwrap_or_else(|e| panic!("Logger initialization failed with {e}"));
    info!("MUST BE REACHED");
    DeferredNow::force_utc();
    panic!("MUST NOT BE REACHED");
}
