# encoding: UTF-8
# frozen_string_literal: true

# This file contains data derived from the IANA Time Zone Database
# (https://www.iana.org/time-zones).

module TZInfo
  module Data
    module Definitions
      module Europe
        module London
          include Format2::TimezoneDefinition

          timezone 'Europe/London' do |tz|
            tz.offset :o0, -75, 0, 'LMT'
            tz.offset :o1, 0, 0, 'GMT'
            tz.offset :o2, 0, 3600, 'BST'
            tz.offset :o3, 0, 7200, 'BDST'
            tz.offset :o4, 3600, 0, 'BST'

            tz.transition :o1, -3852662325
            tz.transition :o2, -1691964000
            tz.transition :o1, -1680472800
            tz.transition :o2, -1664143200
            tz.transition :o1, -1650146400
            tz.transition :o2, -1633903200
            tz.transition :o1, -1617487200
            tz.transition :o2, -1601848800
            tz.transition :o1, -1586037600
            tz.transition :o2, -1570399200
            tz.transition :o1, -1552168800
            tz.transition :o2, -1538344800
            tz.transition :o1, -1522533600
            tz.transition :o2, -1507500000
            tz.transition :o1, -1490565600
            tz.transition :o2, -1473631200
            tz.transition :o1, -1460930400
            tz.transition :o2, -1442786400
            tz.transition :o1, -1428876000
            tz.transition :o2, -1410732000
            tz.transition :o1, -1396216800
            tz.transition :o2, -1379282400
            tz.transition :o1, -1364767200
            tz.transition :o2, -1348437600
            tz.transition :o1, -1333317600
            tz.transition :o2, -1315778400
            tz.transition :o1, -1301263200
            tz.transition :o2, -1284328800
            tz.transition :o1, -1269813600
            tz.transition :o2, -1253484000
            tz.transition :o1, -1238364000
            tz.transition :o2, -1221429600
            tz.transition :o1, -1206914400
            tz.transition :o2, -1189980000
            tz.transition :o1, -1175464800
            tz.transition :o2, -1159135200
            tz.transition :o1, -1143410400
            tz.transition :o2, -1126476000
            tz.transition :o1, -1111960800
            tz.transition :o2, -1095631200
            tz.transition :o1, -1080511200
            tz.transition :o2, -1063576800
            tz.transition :o1, -1049061600
            tz.transition :o2, -1032127200
            tz.transition :o1, -1017612000
            tz.transition :o2, -1001282400
            tz.transition :o1, -986162400
            tz.transition :o2, -969228000
            tz.transition :o1, -950479200
            tz.transition :o2, -942012000
            tz.transition :o3, -904518000
            tz.transition :o2, -896050800
            tz.transition :o3, -875487600
            tz.transition :o2, -864601200
            tz.transition :o3, -844038000
            tz.transition :o2, -832546800
            tz.transition :o3, -812588400
            tz.transition :o2, -798073200
            tz.transition :o3, -781052400
            tz.transition :o2, -772066800
            tz.transition :o1, -764805600
            tz.transition :o2, -748476000
            tz.transition :o1, -733356000
            tz.transition :o2, -719445600
            tz.transition :o3, -717030000
            tz.transition :o2, -706748400
            tz.transition :o1, -699487200
            tz.transition :o2, -687996000
            tz.transition :o1, -668037600
            tz.transition :o2, -654732000
            tz.transition :o1, -636588000
            tz.transition :o2, -622072800
            tz.transition :o1, -605743200
            tz.transition :o2, -590623200
            tz.transition :o1, -574293600
            tz.transition :o2, -558568800
            tz.transition :o1, -542239200
            tz.transition :o2, -527119200
            tz.transition :o1, -512604000
            tz.transition :o2, -496274400
            tz.transition :o1, -481154400
            tz.transition :o2, -464220000
            tz.transition :o1, -449704800
            tz.transition :o2, -432165600
            tz.transition :o1, -417650400
            tz.transition :o2, -401320800
            tz.transition :o1, -386200800
            tz.transition :o2, -369266400
            tz.transition :o1, -354751200
            tz.transition :o2, -337816800
            tz.transition :o1, -323301600
            tz.transition :o2, -306972000
            tz.transition :o1, -291852000
            tz.transition :o2, -276732000
            tz.transition :o1, -257983200
            tz.transition :o2, -245282400
            tz.transition :o1, -226533600
            tz.transition :o2, -213228000
            tz.transition :o1, -195084000
            tz.transition :o2, -182383200
            tz.transition :o1, -163634400
            tz.transition :o2, -150933600
            tz.transition :o1, -132184800
            tz.transition :o2, -119484000
            tz.transition :o1, -100735200
            tz.transition :o2, -88034400
            tz.transition :o1, -68680800
            tz.transition :o2, -59004000
            tz.transition :o4, -37242000
            tz.transition :o1, 57722400
            tz.transition :o2, 69818400
            tz.transition :o1, 89172000
            tz.transition :o2, 101268000
            tz.transition :o1, 120621600
            tz.transition :o2, 132717600
            tz.transition :o1, 152071200
            tz.transition :o2, 164167200
            tz.transition :o1, 183520800
            tz.transition :o2, 196221600
            tz.transition :o1, 214970400
            tz.transition :o2, 227671200
            tz.transition :o1, 246420000
            tz.transition :o2, 259120800
            tz.transition :o1, 278474400
            tz.transition :o2, 290570400
            tz.transition :o1, 309924000
            tz.transition :o2, 322020000
            tz.transition :o1, 341373600
            tz.transition :o2, 354675600
            tz.transition :o1, 372819600
            tz.transition :o2, 386125200
            tz.transition :o1, 404269200
            tz.transition :o2, 417574800
            tz.transition :o1, 435718800
            tz.transition :o2, 449024400
            tz.transition :o1, 467773200
            tz.transition :o2, 481078800
            tz.transition :o1, 499222800
            tz.transition :o2, 512528400
            tz.transition :o1, 530672400
            tz.transition :o2, 543978000
            tz.transition :o1, 562122000
            tz.transition :o2, 575427600
            tz.transition :o1, 593571600
            tz.transition :o2, 606877200
            tz.transition :o1, 625626000
            tz.transition :o2, 638326800
            tz.transition :o1, 657075600
            tz.transition :o2, 670381200
            tz.transition :o1, 688525200
            tz.transition :o2, 701830800
            tz.transition :o1, 719974800
            tz.transition :o2, 733280400
            tz.transition :o1, 751424400
            tz.transition :o2, 764730000
            tz.transition :o1, 782874000
            tz.transition :o2, 796179600
            tz.transition :o1, 814323600
            tz.transition :o2, 828234000
            tz.transition :o1, 846378000
            tz.transition :o2, 859683600
            tz.transition :o1, 877827600
            tz.transition :o2, 891133200
            tz.transition :o1, 909277200
            tz.transition :o2, 922582800
            tz.transition :o1, 941331600
            tz.transition :o2, 954032400
            tz.transition :o1, 972781200
            tz.transition :o2, 985482000
            tz.transition :o1, 1004230800
            tz.transition :o2, 1017536400
            tz.transition :o1, 1035680400
            tz.transition :o2, 1048986000
            tz.transition :o1, 1067130000
            tz.transition :o2, 1080435600
            tz.transition :o1, 1099184400
            tz.transition :o2, 1111885200
            tz.transition :o1, 1130634000
            tz.transition :o2, 1143334800
            tz.transition :o1, 1162083600
            tz.transition :o2, 1174784400
            tz.transition :o1, 1193533200
            tz.transition :o2, 1206838800
            tz.transition :o1, 1224982800
            tz.transition :o2, 1238288400
            tz.transition :o1, 1256432400
            tz.transition :o2, 1269738000
            tz.transition :o1, 1288486800
            tz.transition :o2, 1301187600
            tz.transition :o1, 1319936400
            tz.transition :o2, 1332637200
            tz.transition :o1, 1351386000
            tz.transition :o2, 1364691600
            tz.transition :o1, 1382835600
            tz.transition :o2, 1396141200
            tz.transition :o1, 1414285200
            tz.transition :o2, 1427590800
            tz.transition :o1, 1445734800
            tz.transition :o2, 1459040400
            tz.transition :o1, 1477789200
            tz.transition :o2, 1490490000
            tz.transition :o1, 1509238800
            tz.transition :o2, 1521939600
            tz.transition :o1, 1540688400
            tz.transition :o2, 1553994000
            tz.transition :o1, 1572138000
            tz.transition :o2, 1585443600
            tz.transition :o1, 1603587600
            tz.transition :o2, 1616893200
            tz.transition :o1, 1635642000
            tz.transition :o2, 1648342800
            tz.transition :o1, 1667091600
            tz.transition :o2, 1679792400
            tz.transition :o1, 1698541200
            tz.transition :o2, 1711846800
            tz.transition :o1, 1729990800
            tz.transition :o2, 1743296400
            tz.transition :o1, 1761440400
            tz.transition :o2, 1774746000
            tz.transition :o1, 1792890000
            tz.transition :o2, 1806195600
            tz.transition :o1, 1824944400
            tz.transition :o2, 1837645200
            tz.transition :o1, 1856394000
            tz.transition :o2, 1869094800
            tz.transition :o1, 1887843600
            tz.transition :o2, 1901149200
            tz.transition :o1, 1919293200
            tz.transition :o2, 1932598800
            tz.transition :o1, 1950742800
            tz.transition :o2, 1964048400
            tz.transition :o1, 1982797200
            tz.transition :o2, 1995498000
            tz.transition :o1, 2014246800
            tz.transition :o2, 2026947600
            tz.transition :o1, 2045696400
            tz.transition :o2, 2058397200
            tz.transition :o1, 2077146000
            tz.transition :o2, 2090451600
            tz.transition :o1, 2108595600
            tz.transition :o2, 2121901200
            tz.transition :o1, 2140045200
            tz.transition :o2, 2153350800
            tz.transition :o1, 2172099600
            tz.transition :o2, 2184800400
            tz.transition :o1, 2203549200
            tz.transition :o2, 2216250000
            tz.transition :o1, 2234998800
            tz.transition :o2, 2248304400
            tz.transition :o1, 2266448400
            tz.transition :o2, 2279754000
            tz.transition :o1, 2297898000
            tz.transition :o2, 2311203600
            tz.transition :o1, 2329347600
            tz.transition :o2, 2342653200
            tz.transition :o1, 2361402000
            tz.transition :o2, 2374102800
            tz.transition :o1, 2392851600
            tz.transition :o2, 2405552400
            tz.transition :o1, 2424301200
            tz.transition :o2, 2437606800
            tz.transition :o1, 2455750800
            tz.transition :o2, 2469056400
            tz.transition :o1, 2487200400
            tz.transition :o2, 2500506000
            tz.transition :o1, 2519254800
            tz.transition :o2, 2531955600
            tz.transition :o1, 2550704400
            tz.transition :o2, 2563405200
            tz.transition :o1, 2582154000
            tz.transition :o2, 2595459600
            tz.transition :o1, 2613603600
            tz.transition :o2, 2626909200
            tz.transition :o1, 2645053200
            tz.transition :o2, 2658358800
            tz.transition :o1, 2676502800
            tz.transition :o2, 2689808400
            tz.transition :o1, 2708557200
            tz.transition :o2, 2721258000
            tz.transition :o1, 2740006800
            tz.transition :o2, 2752707600
            tz.transition :o1, 2771456400
            tz.transition :o2, 2784762000
            tz.transition :o1, 2802906000
            tz.transition :o2, 2816211600
            tz.transition :o1, 2834355600
            tz.transition :o2, 2847661200
            tz.transition :o1, 2866410000
            tz.transition :o2, 2879110800
            tz.transition :o1, 2897859600
            tz.transition :o2, 2910560400
            tz.transition :o1, 2929309200
            tz.transition :o2, 2942010000
            tz.transition :o1, 2960758800
            tz.transition :o2, 2974064400
            tz.transition :o1, 2992208400
            tz.transition :o2, 3005514000
            tz.transition :o1, 3023658000
            tz.transition :o2, 3036963600
            tz.transition :o1, 3055712400
            tz.transition :o2, 3068413200
            tz.transition :o1, 3087162000
            tz.transition :o2, 3099862800
            tz.transition :o1, 3118611600
            tz.transition :o2, 3131917200
            tz.transition :o1, 3150061200
            tz.transition :o2, 3163366800
            tz.transition :o1, 3181510800
          end
        end
      end
    end
  end
end
