;;; rg-info-hack.el --- Make sure rg.el info documentation looks good -*- lexical-binding: t; -*-

;; Copyright (C) 2019 David Landell <david.landell@sunnyhill.email>
;;
;; Author: David Landell <david.landell@sunnyhill.email>
;; URL: https://github.com/dajva/rg.el

;; This file is not part of GNU Emacs.

;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License
;; as published by the Free Software Foundation; either version 3
;; of the License, or (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
;; 02110-1301, USA.

;;; Commentary:

;;; Code:
(require 'info)

(define-advice info-insert-file-contents
    (:after (&rest _) sphinx-info-insert-file-contents)
  "Hack to hide \"See\" in references.
This makes `Info-hide-note-references' buffer-local and
automatically set to `hide' iff it can be determined that this file
is the rg.el documentation and was created from a Texinfo file
  generated by Sphinx."
  (set (make-local-variable
	'Info-hide-note-references)
       (default-value 'Info-hide-note-references))
  (save-excursion
    (save-restriction
      (widen) (goto-char (point-min))
      (when (and (search-forward "* RG:" nil t)
                 (search-forward
                  "Generated by Sphinx"
                  (save-excursion (search-forward "\x1f" nil t)) t))
        (set (make-local-variable 'Info-hide-note-references)
             'hide)))))

(provide 'rg-info-hack)

;;; rg-info-hack.el ends here
