## RabbitMQ 3.8.0

RabbitMQ `3.8.0` is a feature release. It contains several major improvements in areas of
data safety, replication, observability, and ease of upgrades. Some highlight features are

 * [Quorum Queues](http://next.rabbitmq.com/quorum-queues.html)
 * Built-in [Prometheus support](http://next.rabbitmq.com/prometheus.html) with a set of Grafana dashboards to complement it
 * [Feature Flags](http://next.rabbitmq.com/feature-flags.html)
 * [Single Active Consumer](http://next.rabbitmq.com/consumers.html#single-active-consumer)
 * New authentication and authorisation [backend that uses OAuth 2.0 (JWT)](https://github.com/rabbitmq/rabbitmq-auth-backend-oauth2) tokens and scopes

A recorded webinar, [What's New in RabbitMQ 3.8](https://content.pivotal.io/webinars/may-23-what-s-new-in-rabbitmq-3-8-webinar), covers some of the highlights in this release.

Several features in this release are backed by a new Raft implementation for Erlang and Elixir,
[Ra](https://github.com/rabbitmq/ra/).

### Erlang/OTP Compatibility Notes

This release [**requires Erlang/OTP 21.3**](https://www.rabbitmq.com/which-erlang.html) or later.
`22.x` series is recommended.

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision latest patch versions of Erlang `21.3.x` and `22.x`.


### Rolling Upgrades to 3.8

RabbitMQ 3.8.0 nodes can run alongside `3.7.18` or later `3.7.x` nodes.
No 3.8.0-specific features would be available in a mixed version cluster. Mixed versions are meant
to simplify rolling upgrades and not meant to be running for long periods of time.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for documentation on upgrades.


### Compatibility Notes

#### Upgrading to Erlang 21.x or Later Versions

When upgrading to this release **and upgrading Erlang to 21.x or later** at the same time, extra care has to be taken.
Since CLI tools from RabbitMQ releases older than 3.7.7 will fail on Erlang 21 or later,
RabbitMQ **must be upgraded before Erlang**.

#### Upgrade Doc Guides and Change Log

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for documentation on upgrades
and [RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

#### Client Library Compatibility

Client libraries that were compatible with RabbitMQ `3.7.x` will be compatible with `3.8.0`.


### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the
[RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users).


## Changes

### Core Server

#### Enhancements

 * [Quorum Queues](http://next.rabbitmq.com/quorum-queues.html) built on top of the [Raft consensus algorithm](https://raft.github.io/) for data safety,
   more predictable failure recovery, more efficient synchronisation of new and recovered followers, and parallel replication.

 * [Feature Flags](http://next.rabbitmq.com/feature-flags.html) allow for mixed-version clusters and safer rolling upgrades.

 * [Single Active Consumer](http://next.rabbitmq.com/consumers.html#single-active-consumer) makes it possible
   to run a set of consumers for redundancy while ensuring that only one consumer is getting deliveries.

 * New metric: dropped unroutable messages. Spotting faulty publishers and routing topology issues is now easier.

   GitHub issue: [rabbitmq/rabbitmq-server#1904](https://github.com/rabbitmq/rabbitmq-server/issues/1904)

 * New metrics: [connection](https://www.rabbitmq.com/connections.html#monitoring) and [channel churn](https://www.rabbitmq.com/channels.html#monitoring).

   GitHub issue: [rabbitmq/rabbitmq-server#1723](https://github.com/rabbitmq/rabbitmq-server/issues/1723)

 * Quorum queues support redelivery tracking, which can be used by consumers to protect themselves from
   poison message redeliveries.

   GitHub issue: [rabbitmq/rabbitmq-server#502](https://github.com/rabbitmq/rabbitmq-server/issues/502)

 * New queue overflow behaviour: `reject-publish-dlx`. It is identical to `reject-publish`
   but also dead letters rejected messages.

   GitHub issue: [rabbitmq/rabbitmq-server#1443](https://github.com/rabbitmq/rabbitmq-server/issues/1443)

 * Default bindings are now explicit instead of being rows in the internal data store. That means
   that high queue churn results in significantly less binding churn, reducing lock contention on
   schema database tables, and peak schema operation latencies with it.

   GitHub issue: [rabbitmq/rabbitmq-server#1721](https://github.com/rabbitmq/rabbitmq-server/pull/1721)

#### Internal API Changes

 * [`amqqueue`](https://github.com/rabbitmq/rabbitmq-server/blob/master/src/amqqueue.erl) is a new public API module
   that should be used to access queue state instead of using queue state records directly. This allows the record
   to evolve a lot more rapidly with fewer or no code changes in the plugins that access queue state.

 * `authn` and `authz` functions now have access to additional (e.g. protocol-specific) context information.

   GitHub issue: [rabbitmq/rabbitmq-server#1767](https://github.com/rabbitmq/rabbitmq-server/issues/1767)

 * Backing queue interface now exposes a function for message deduplication. Plugins now can track duplicate messages
   in a way that makes it possible to negatively confirm duplicates back to the publisher.

   Contributed by Matteo Cafasso.

   GitHub issue: [rabbitmq/rabbitmq-server#1774](https://github.com/rabbitmq/rabbitmq-server/pull/1774).

#### Usability

 * New style configuration format is now more forgiving: it will ignore lines that only contain
   whitespace and tab characters, as well as leading and trailing whitespace.

   GitHub issue: [rabbitmq/rabbitmq-server#2072](https://github.com/rabbitmq/rabbitmq-server/pull/2072)

 * Maximum message size is now configurable. The default was reduced to 128 MiB.e

   GitHub issue: [rabbitmq/rabbitmq-server#1812](https://github.com/rabbitmq/rabbitmq-server/pull/1812)

#### Bug Fixes

Most bug fixes in this release previously shipped in [`3.7.x` release series](https://rabbitmq.com/changelog.html).
The list below contains community contributions and most important issues that were not backported to `3.7.x` releases.

 * Queue index consistency and safety improvements.

   Contributed by @tomyouyou.

   GitHub issues: [rabbitmq/rabbitmq-server#2092](https://github.com/rabbitmq/rabbitmq-server/pull/2092), [rabbitmq/rabbitmq-server#2096](https://github.com/rabbitmq/rabbitmq-server/pull/2096), [rabbitmq/rabbitmq-server#2100](https://github.com/rabbitmq/rabbitmq-server/pull/2100).


### CLI Tools

#### Enhancements

 * More user-friendly `rabbitmq-diagnostics status` output.

   GitHub issue: [rabbitmq/rabbitmq-cli#340](https://github.com/rabbitmq/rabbitmq-cli/issues/340)

 * New `help` command.

   GitHub issue: [rabbitmq/rabbitmq-cli#316](https://github.com/rabbitmq/rabbitmq-cli/pull/316)

 * A new set of fine-grained [health check](https://www.rabbitmq.com/monitoring.html#health-checks) commands.

   GitHub issue: [rabbitmq/rabbitmq-cli#292](https://github.com/rabbitmq/rabbitmq-cli/issues/292)

 * New tool, `rabbitmq-queues`, with commands that display Raft state metrics and manage nodes that
   host quorum queue replicas.

   GitHub issues: [rabbitmq/rabbitmq-cli#287](https://github.com/rabbitmq/rabbitmq-cli/issues/287), [rabbitmq/rabbitmq-cli#286](https://github.com/rabbitmq/rabbitmq-cli/issues/286)

 * Feature flag status reporting.

   GitHub issue: [rabbitmq/rabbitmq-cli#346](https://github.com/rabbitmq/rabbitmq-cli/issues/346)

#### Usability

 * `rabbitmq-diagnostics cipher_suites` now uses OpenSSL cipher suite format by default.

   GitHub issue: [rabbitmq/rabbitmq-cli#267](https://github.com/rabbitmq/rabbitmq-cli/issues/267)


### Management Plugin

#### Enhancements

 * Metric collection and visualisation in management UI now can be disabled in favor of built-in
   Prometheus support and Grafana dashboard from Team RabbitMQ.

   GitHub issue: [rabbitmq/rabbitmq-management#707](https://github.com/rabbitmq/rabbitmq-management/pull/707)

 * Feature flag management interface.

   [rabbitmq/rabbitmq-management#648](https://github.com/rabbitmq/rabbitmq-management/pull/648)

 * Quorum Queue support.

 * Single Active Consumer support.

   GitHub issue: [rabbitmq/rabbitmq-management#650](https://github.com/rabbitmq/rabbitmq-management/pull/650)

 * Support for more TLS options.

   GitHub issue: [rabbitmq/rabbitmq-management#644](https://github.com/rabbitmq/rabbitmq-management/pull/644)

 * OAuth 2.0 Single Sign On support for [UAA](https://docs.cloudfoundry.org/concepts/architecture/uaa.html)

   GitHub issue: [rabbitmq/rabbitmq-management#722](https://github.com/rabbitmq/rabbitmq-management/pull/722)

 * Username and password-based Basic HTTP Auth authentication for API operations now can be disabled
   in favor of OAuth 2.0 Single Sign On via [UAA](https://docs.cloudfoundry.org/concepts/architecture/uaa.html).

   GitHub issue: [rabbitmq/rabbitmq-management#724](https://github.com/rabbitmq/rabbitmq-management/pull/724)


### Shovel Plugin

#### Bug Fixes

Most bug fixes in this release previously shipped in [`3.7.x` release series](https://rabbitmq.com/changelog.html).
The list below contains most prominent fixes.

 * Sensitive values in Shovel connection state (namely, the connection credentials) are now stored in
   encrypted form. This avoids unintentional credential logging by the runtime (exception logger)
   at the cost of making troubleshooting authentication failures harder.

   GitHub issue: [rabbitmq-erlang-client#123](https://github.com/rabbitmq/rabbitmq-erlang-client/issues/123)


### Federation Plugin

#### Bug Fixes

Most bug fixes in this release previously shipped in [`3.7.x` release series](https://rabbitmq.com/changelog.html).
The list below contains most prominent fixes.

 * Sensitive values in federation link state (namely, the connection credentials) are now stored in
   encrypted form. This avoids unintentional credential logging by the runtime (exception logger)
   at the cost of making troubleshooting authentication failures harder.

   GitHub issue: [rabbitmq-erlang-client#123](https://github.com/rabbitmq/rabbitmq-erlang-client/issues/123)


### JWT and OAuth 2.0 Plugin

Initial release.

GitHub repository: [rabbitmq/rabbitmq-auth-backend-oauth2](https://github.com/rabbitmq/rabbitmq-auth-backend-oauth2)


### MQTT Plugin

#### Enhancements

 * Client ID tracking is now cluster-wide (state is replicated across all nodes). A majority of nodes is required
   for client connections to be accepted. This is a consequence of the neew consistency-oriented design.

   GitHub issue: [rabbitmq/rabbitmq-mqtt#91](https://github.com/rabbitmq/rabbitmq-mqtt/issues/91)


### Web STOMP Plugin

#### Bug Fixes

Most bug fixes in this release previously shipped in [`3.7.x` release series](https://rabbitmq.com/changelog.html).
The list below contains most prominent fixes.

 * Maximum concurrent client connection limit now defaults to "infinity" (so, there is no limit).

   GitHub issue: [rabbitmq/rabbitmq-web-stomp#113](https://github.com/rabbitmq/rabbitmq-web-stomp/issues/113)


### Web MQTT Plugin

#### Bug Fixes

Most bug fixes in this release previously shipped in [`3.7.x` release series](https://rabbitmq.com/changelog.html).
The list below contains most prominent fixes.

 * Maximum concurrent client connection limit now defaults to "infinity" (so, there is no limit).

   GitHub issue: [rabbitmq/rabbitmq-web-mqtt#28](https://github.com/rabbitmq/rabbitmq-web-mqtt/issues/28)


### RabbitMQ Erlang Client

#### Bug Fixes

Most bug fixes in this release previously shipped in [`3.7.x` release series](https://rabbitmq.com/changelog.html).
The list below contains most prominent fixes.

 * Sensitive values in connection state (namely, the connection credentials) are now stored in
   encrypted form. This avoids unintentional credential logging by the runtime (exception logger)
   at the cost of making troubleshooting authentication failures harder.

   GitHub issue: [rabbitmq-erlang-client#123](https://github.com/rabbitmq/rabbitmq-erlang-client/issues/123)


## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-server-3.8.0.tar.xz`.
