## RabbitMQ 3.8.20

RabbitMQ `3.8.20` is a maintenance release.

### Obtaining Packages

RabbitMQ releases are distributed via [GitHub](https://github.com/rabbitmq/rabbitmq-server/releases), [Cloudsmith](https://cloudsmith.io/~rabbitmq/repos/),
and [PackageCloud](https://packagecloud.io/rabbitmq).

### Erlang/OTP Compatibility Notes

This release [requires Erlang 23.2](https://www.rabbitmq.com/which-erlang.html) and [supports Erlang 24](https://blog.rabbitmq.com/posts/2021/03/erlang-24-support-roadmap/).

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision modern Erlang versions.


## Upgrade and Compatibility Notes

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades and
[RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

If upgrading from a`3.7.x` release, see [3.8.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.8.0)
upgrade and compatibility notes first.

If upgrading from a `3.6.x` or older [release series](https://www.rabbitmq.com/versions.html), first upgrade
to [`3.7.27`](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.27) and then to this version.


## Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the [RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users)
and [RabbitMQ community Slack](https://rabbitmq-slack.herokuapp.com/).


## Changes Worth Mentioning

Release notes are kept under [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.8.x/release-notes).
Contributors are encouraged to update them together with their changes.  This helps with release automation and more
consistent release schedule.

### Core Server

#### Enhancements

 * Nodes failed to start when hostname contained non-ASCII (broader Unicode) characters.

   GitHub issue: [#3239](https://github.com/rabbitmq/rabbitmq-server/pull/3239)

 * TLS information delivered in [Proxy protocol](https://www.rabbitmq.com/networking.html#proxy-protocol) header
   is now attached to connection metrics as if it was provided by a non-proxying client.

   GitHub issue: [#3175](https://github.com/rabbitmq/rabbitmq-server/pull/3175) contributed by @prefiks


### CLI Tools

#### Bug Fixes

 * `rabbitmq-upgrade drain` and `rabbitmq-upgrade revive` now log and `warning` and `info`
   level instead of `alert` (that can show up as `error`).

   GitHub issue: [#3266](https://github.com/rabbitmq/rabbitmq-server/pull/3266)


### Management Plugin

#### Bug Fixes

  * HTTP API now includes `WWW-Authentiate` header into 401 responses
    to requests that contain invalid credentials

    GitHub issue: [#3181](https://github.com/rabbitmq/rabbitmq-server/issues/3181)

  * Queue name is now validated for length according to the AMQP 0-9-1 spec.

    GitHub issue: [#3202](https://github.com/rabbitmq/rabbitmq-server/pull/3202)


### Shovel Plugin

#### Bug Fixes

 * Multiple Shovels could be started in some cases involving node restarts of failures.

   GitHub issue: [#3260](https://github.com/rabbitmq/rabbitmq-server/issues/3260)


### Federation Plugin

#### Bug Fixes

 * Multiple Federation links could be started in some cases involving node restarts of failures.

   GitHub issue: [#3260](https://github.com/rabbitmq/rabbitmq-server/issues/3260)


### RabbitMQ Erlang Client

#### Bug Fixes

 * New releases of the client are again published to Hex.pm.

   GitHub issue: [#3247](https://github.com/rabbitmq/rabbitmq-server/pull/3247)

 * `connection_timeout` was adjusted to avoid a confusing warning.

   GitHub issue: [#3232](https://github.com/rabbitmq/rabbitmq-server/pull/3232) contributed by @britto

 * Corrected a typo in direct connection net tick time adjustment.

   GitHub issue: [#3233](https://github.com/rabbitmq/rabbitmq-server/pull/3233) contributed by @britto



## Dependency Upgrades

No dependency changes in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.8.20.tar.xz`
instead of the source tarball produced by GitHub.
