% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TMB.R
\name{newton}
\alias{newton}
\title{Generalized newton optimizer.}
\usage{
newton(par, fn, gr, he, trace = 1, maxit = 100, tol = 1e-08, alpha = 1,
  smartsearch = TRUE, mgcmax = 1e+60, super = TRUE, silent = TRUE,
  ustep = 1, power = 0.5, u0 = 1e-04, grad.tol = tol, step.tol = tol,
  tol10 = 0.001, env = environment(), ...)
}
\arguments{
\item{par}{Initial parameter.}

\item{fn}{Objective function.}

\item{gr}{Gradient function.}

\item{he}{Sparse hessian function.}

\item{trace}{Print tracing information?}

\item{maxit}{Maximum number of iterations.}

\item{tol}{Convergence tolerance.}

\item{alpha}{Newton stepsize in the fixed stepsize case.}

\item{smartsearch}{Turn on adaptive stepsize algorithm for non-convex problems?}

\item{mgcmax}{Refuse to optimize if the maximum gradient component is too steep.}

\item{super}{Supernodal Cholesky?}

\item{silent}{Be silent?}

\item{ustep}{Adaptive stepsize initial guess between 0 and 1.}

\item{power}{Parameter controlling adaptive stepsize.}

\item{u0}{Parameter controlling adaptive stepsize.}

\item{grad.tol}{Gradient convergence tolerance.}

\item{step.tol}{Stepsize convergence tolerance.}

\item{tol10}{Try to exit if last 10 iterations not improved more than this.}

\item{env}{Environment for cached Cholesky factor.}

\item{...}{Currently unused.}
}
\value{
List with solution similar to \code{optim} output.
}
\description{
Generalized newton optimizer used for the inner optimization problem.
}
\details{
If \code{smartsearch=FALSE} this function performs an ordinary newton optimization
on the function \code{fn} using an exact sparse hessian function.
A fixed stepsize may be controlled by \code{alpha} so that the iterations are
given by:
\deqn{u_{n+1} = u_n - \alpha f''(u_n)^{-1}f'(u_n)}

If \code{smartsearch=TRUE} the hessian is allowed to become negative definite
preventing ordinary newton iterations. In this situation the newton iterations are performed on
a modified objective function defined by adding a quadratic penalty around the expansion point \eqn{u_0}:
\deqn{f_{t}(u) = f(u) + \frac{t}{2} \|u-u_0\|^2}{f_t(u) = f(u) + t/2 |u-u_0|^2}
This function's hessian ( \eqn{f''(u)+t I} ) is positive definite for \eqn{t} sufficiently
large. The value \eqn{t} is updated at every iteration: If the hessian is positive definite \eqn{t} is
decreased, otherwise increased. Detailed control of the update process can be obtained with the
arguments \code{ustep}, \code{power} and \code{u0}.
}
\seealso{
\code{\link{newtonOption}}
}
