% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectrum.R
\name{spectratype}
\alias{spectratype}
\title{Spectratype}
\usage{
spectratype(
  .data,
  .quant = c("read.count", "umi.count", "id"),
  .gene = "V",
  .plot = T,
  .main = "Spectratype",
  .legend = "Gene segment",
  .labs = c("CDR3 length", NA)
)
}
\arguments{
\item{.data}{tcR data frame.}

\item{.quant}{Either "read.count" or "umi.count" for choosing the corresponding columns, or "id" to compute avoid using counts.}

\item{.gene}{Either NA for not using genes, "V" or "J" for corresponding genes.}

\item{.plot}{If T than plot the spectratype plot, otherwise return a table with data for lengths and counts.}

\item{.main}{Main title.}

\item{.legend}{Legend title.}

\item{.labs}{Character vector of length 2 for x-lab and y-lab.}
}
\description{
Plot a spectratype plot - a histogram of read counts / umi counts by CDR3 length.
}
\examples{
\dontrun{
data(twb)
tmp = twb[[1]]
spectratype(tmp)
spectratype(tmp, .quant = "id", .plot = T, .gene = 'V')
spectratype(tmp, .quant = "read.count", .plot = F)
}
}
