% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{st_rgb}
\alias{st_rgb}
\title{reduce dimension to rgb (alpha) hex values}
\usage{
st_rgb(
  x,
  dimension = 3,
  use_alpha = FALSE,
  maxColorValue = 255L,
  probs = c(0, 1),
  stretch = FALSE
)
}
\arguments{
\item{x}{object of class \code{stars}}

\item{dimension}{dimension name or number to reduce}

\item{use_alpha}{logical; if TRUE, the fourth band will be used as alpha values}

\item{maxColorValue}{integer; maximum value for colors}

\item{probs}{probability values for quantiles used for stretching}

\item{stretch}{logical; if \code{TRUE}, each band is stretched to 0 ... \code{maxColorValue}}
}
\description{
reduce dimension to rgb (alpha) hex values
}
\details{
the dimension's bands are mapped to red, green, blue, alpha; if a different 
ordering is wanted, use \link{[.stars} to reorder a dimension, see examples
}
\examples{
tif = system.file("tif/L7_ETMs.tif", package = "stars")
x = read_stars(tif)
st_rgb(x, 3)
r = st_rgb(x[,,,c(6,5,4,3)], 3, use_alpha=TRUE) # now R=6,G=5,B=4,alpha=3
if (require(ggplot2)) {
 ggplot() + geom_stars(data = r) + scale_fill_identity()
}
}
\seealso{
\link{st_apply}, \link[grDevices]{rgb}
}
