% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sendmailR.r
\name{sendmail}
\alias{sendmail}
\title{Send mail from within R}
\usage{
sendmail(
  from,
  to,
  subject,
  msg,
  cc,
  bcc,
  ...,
  engine = c("internal", "curl", "debug"),
  headers = list(),
  control = list(),
  engineopts = list()
)
}
\arguments{
\item{from}{From whom the mail message is (RFC2822 style address).}

\item{to}{Recipient of the message (vector of valid RFC2822 style addresses).}

\item{subject}{Subject line of message.}

\item{msg}{Body text of message or a list containing
\code{\link{mime_part}} objects.}

\item{cc}{Carbon-copy recipients (vector of valid RFC2822 style addresses).}

\item{bcc}{Blind carbon-copy recipients (vector of valid RFC2822 style addresses).}

\item{\dots}{...}

\item{engine}{One of: \itemize{
\item{\code{"internal"} for the internal smtp transport (default).}
\item{\code{"curl"} for the use of curl for transport. Enable if you need STARTTLS/SSL
and/or SMTP authentication. See \code{curl::\link[curl]{send_mail}}.}
\item{\code{"debug"} sendmail returns a RFC2822 formatted email message without sending it.}
}}

\item{headers}{Any other headers to include.}

\item{control}{List of SMTP server settings. Valid values are the
possible options for \code{\link{sendmail_options}}.}

\item{engineopts}{Options passed to curl if using the curl backend. \itemize{
\item{For authentication pass a list with \code{username} and \code{password}.}
\item{\code{use_ssl} defaults to "force" if unset.}
\item{For available options run \code{curl::\link[curl]{curl_options}}.}
}}
}
\description{
Simplistic sendmail utility for R. Uses SMTP to submit a message
to a local SMTP server.
}
\examples{
\dontrun{
from <- sprintf("<sendmailR@\\\\\%s>", Sys.info()[4])
to <- "<olafm@datensplitter.net>"
subject <- "Hello from R"
body <- list("It works!", mime_part(iris))
sendmail(from, to, subject, body,
         control=list(smtpServer="ASPMX.L.GOOGLE.COM"))

sendmail(from="from@example.org",
  to=c("to1@example.org", "to2@example.org"),
  subject="SMTP auth test",
  msg=mime_part("This message was send using sendmailR and curl."),
  engine = "curl",
  engineopts = list(username = "foo", password = "bar"),
  control=list(smtpServer="smtp://smtp.gmail.com:587", verbose = TRUE)
)
}
}
\seealso{
\code{\link{mime_part}} for a way to add attachments.

\code{curl::\link[curl]{send_mail}} for curl SMTP URL specification.
}
\keyword{utilities}
