### Terrence D. Jorgensen
### Last updated: 4 April 2017
### document example data sets


#' Simulated Dataset to Demonstrate Two-way Latent Interaction
#' 
#' A simulated data set with 2 independent factors and 1 dependent factor where
#' each factor has three indicators
#' 
#' 
#' @format A \code{data.frame} with 500 observations of 9 variables.
#' \describe{
#' \item{x1}{The first indicator of the first independent factor}
#' \item{x2}{The second indicator of the first independent factor}
#' \item{x3}{The third indicator of the first independent factor}
#' \item{x4}{The first indicator of the second independent factor}
#' \item{x5}{The second indicator of the second independent factor}
#' \item{x6}{The third indicator of the second independent factor}
#' \item{x7}{The first indicator of the dependent factor}
#' \item{x8}{The second indicator of the dependent factor}
#' \item{x9}{The third indicator of the dependent factor}
#' }
#' @source Data were generated by the \code{\link[MASS]{mvrnorm}} function in
#'   the \code{MASS} package.
#' @examples  head(dat2way)
"dat2way"



#' Simulated Dataset to Demonstrate Three-way Latent Interaction
#' 
#' A simulated data set with 3 independent factors and 1 dependent factor where
#' each factor has three indicators
#' 
#' 
#' @format A \code{data.frame} with 500 observations of 12 variables.
#' \describe{
#' \item{x1}{The first indicator of the first independent factor}
#' \item{x2}{The second indicator of the first independent factor}
#' \item{x3}{The third indicator of the first independent factor}
#' \item{x4}{The first indicator of the second independent factor}
#' \item{x5}{The second indicator of the second independent factor}
#' \item{x6}{The third indicator of the second independent factor}
#' \item{x7}{The first indicator of the third independent factor}
#' \item{x8}{The second indicator of the third independent factor}
#' \item{x9}{The third indicator of the third independent factor}
#' \item{x10}{The first indicator of the dependent factor}
#' \item{x11}{The second indicator of the dependent factor}
#' \item{x12}{The third indicator of the dependent factor}
#' }
#' @source Data were generated by the \code{\link[MASS]{mvrnorm}} function in
#'   the \code{MASS} package.
#' @examples head(dat3way)
"dat3way"



#' Simulated Data set to Demonstrate Categorical Measurement Invariance
#' 
#' A simulated data set with 2 factors with 4 indicators each separated into
#' two groups
#' 
#' 
#' @format A \code{data.frame} with 200 observations of 9 variables. 
#' \describe{
#' \item{g}{Sex of respondents}
#' \item{u1}{Indicator 1}
#' \item{u2}{Indicator 2}
#' \item{u3}{Indicator 3}
#' \item{u4}{Indicator 4}
#' \item{u5}{Indicator 5}
#' \item{u6}{Indicator 6}
#' \item{u7}{Indicator 7}
#' \item{u8}{Indicator 8}
#' }
#' @source Data were generated using the \code{lavaan} package.
#' @examples head(datCat)
"datCat"


#' Simulated Data set to Demonstrate Longitudinal Measurement Invariance
#' 
#' A simulated data set with 1 factors with 3 indicators in three timepoints
#' 
#' 
#' @format A \code{data.frame} with 200 observations of 10 variables.
#' \describe{
#' \item{sex}{Sex of respondents}
#' \item{y1t1}{Indicator 1 in Time 1}
#' \item{y2t1}{Indicator 2 in Time 1}
#' \item{y3t1}{Indicator 3 in Time 1}
#' \item{y1t2}{Indicator 1 in Time 2}
#' \item{y2t2}{Indicator 2 in Time 2}
#' \item{y3t2}{Indicator 3 in Time 2}
#' \item{y1t3}{Indicator 1 in Time 3}
#' \item{y2t3}{Indicator 2 in Time 3}
#' \item{y3t3}{Indicator 3 in Time 3}
#' }
#' @source Data were generated using the \code{simsem} package.
#' @examples head(exLong)
"exLong"



#' Simulated Data set to Demonstrate Random Allocations of Parcels
#' 
#' A simulated data set with 2 factors with 9 indicators for each factor
#' 
#' 
#' @format A \code{data.frame} with 800 observations of 18 variables.
#' \describe{
#' \item{f1item1}{Item 1 loading on factor 1}
#' \item{f1item2}{Item 2 loading on factor 1}
#' \item{f1item3}{Item 3 loading on factor 1} 
#' \item{f1item4}{Item 4 loading on factor 1} 
#' \item{f1item5}{Item 5 loading on factor 1}
#' \item{f1item6}{Item 6 loading on factor 1} 
#' \item{f1item7}{Item 7 loading on factor 1} 
#' \item{f1item8}{Item 8 loading on factor 1} 
#' \item{f1item9}{Item 9 loading on factor 1}
#' \item{f2item1}{Item 1 loading on factor 2}
#' \item{f2item2}{Item 2 loading on factor 2} 
#' \item{f2item3}{Item 3 loading on factor 2} 
#' \item{f2item4}{Item 4 loading on factor 2} 
#' \item{f2item5}{Item 5 loading on factor 2} 
#' \item{f2item6}{Item 6 loading on factor 2}
#' \item{f2item7}{Item 7 loading on factor 2} 
#' \item{f2item8}{Item 8 loading on factor 2} 
#' \item{f2item9}{Item 9 loading on factor 2}
#' }
#' @source Data were generated using the \code{simsem} package.
#' @examples head(simParcel)
"simParcel"



