% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter_points_rgbwt.R
\name{scatter_points_rgbwt}
\alias{scatter_points_rgbwt}
\title{scatter_points_rgbwt}
\usage{
scatter_points_rgbwt(
  xy,
  xlim = c(min(xy[, 1]), max(xy[, 1])),
  ylim = c(min(xy[, 2]), max(xy[, 2])),
  out_size = c(512, 512),
  RGBA = c(0, 0, 0, 255),
  map = NULL,
  palette = NULL
)
}
\arguments{
\item{xy}{2-column matrix with N point coordinates (X and Y) in rows.}

\item{xlim, ylim}{2-element vector of rendered area limits (position of the first pixel on the
left/top, and the last pixel on the right/bottom).
You can flip the image coordinate system by flipping the \verb{*lim} vectors.}

\item{out_size}{2-element vector size of the result raster, defaults to \code{c(512L,512L)}.}

\item{RGBA}{Point colors. Either a 4-element vector that specifies the same color for all points,
or 4-by-N matrix that specifies color for each of the individual points.
Color is specified using integer RGBA; i.e. the default black is \code{c(0,0,0,255)}.}

\item{map}{Vector with N integer indices to \code{palette}. Overrides RGBA-based coloring.}

\item{palette}{Matrix 4-by-K matrix of RGBA colors used as a palette lookup for the \code{map}
that gives the point colors. K is at least \code{max(map)}.
Notably, using a palette may be faster than filling and processing the whole RGBA matrix.}
}
\value{
A RGBWT array with the rendered points.
}
\description{
Render colored points into a RGBWT bitmap
}
