/****************************************************************
*	$ Log: denoise.h,v	$				*
*               (c) Copyright  1994                             *
*                          by                                   *
*      Author: Rene Carmona, Bruno Torresani, Wen-Liang Hwang   *
*                  University of California, Irvine             *
*                  All right reserved                           *
****************************************************************/






/**************************************************************************

Type definitions:
	wave
	WT
**************************************************************************/

#include "complex.h"



/**************************************************************************
*  Function declarations:
**************************************************************************/


/* In FFT.c
   --------*/
void double_fft(double *Or,double *Oi,double *Ir,double *Ii,
  int isize,int isign);



/* In four1.c
   ----------*/
void four1(double data[],int nn,int isign);



/* In cwt_maxima.c
   ---------------*/
void Scwt_gmax(double *input, double *output, int *pnrow, int *pncol, int *posvector);

void Scwt_mridge(double *input, double *output, int *pnrow, int *pncol);



/* In cwt_phase.c
   --------------*/
void morlet_frequencyph(double cf,double scale,double *w,
  double *wd,int isize);

void normalization(double *Oreal, double *Oimage, double *Odreal,
  double *Odimage, int cwtlength);

void f_function(double *Oreal, double *Oimage, double *Odreal,
  double *Odimage, double *f, double cf,int inputsize,int nbvoice,
  int nboctave);

void Scwt_phase(double *input, double *Oreal, double *Oimage,
  double *f, int *pnboctave, int *pnbvoice, int *pinputsize,
  double *pcenterfrequency);

void w_reassign(double *Oreal, double *Oimage, double *Odreal,
  double *Odimage, double *squeezed_r, double *squeezed_i, double cf,
  int inputsize,int nbvoice,int nboctave);

void Scwt_squeezed(double *input, double *squeezed_r,
  double *squeezed_i, int *pnboctave, int *pnbvoice,
  int *pinputsize, double *pcenterfrequency);



/* In cwt_morlet.c
   ---------------*/
void multi(double *Ri1, double *Ii1, double *Ri2, double *Or,
   double *Oi, int isize);

void morlet_frequency(double cf,double scale,double *w,int isize);

void morlet_time(double *pcf, double *pscale, int *pb, 
		 double *w_r, double *w_i, int *pisize);
//void morlet_time(double *pcf, double *pscale, int *pb, 
//		 fcomplex *w, int *pisize);

void vmorlet_time(double *pcf,double *pscale, int *b, 
		 double *w_r, double *w_i,int *pisize, int *pnbnode);

void Scwt_morlet_r(double *input, double *Oreal, double *Oimage,
   int *pnboctave, int *pnbvoice, int *pinputsize, double *pcenterfrequency);

void Scwt_morlet(double *Rinput,double *Iinput,double *Oreal,
   double *Oimage,int *pnboctave,int *pnbvoice,
   int *pinputsize,double *pcenterfrequency);

void Svwt_morlet(double *Rinput,double *Iinput,double *Oreal,
   double *Oimage,double *pa,int *pinputsize,
   double *pcenterfrequency);



/* In cwt_thierry.c
   ----------------*/
void thierry_frequency(int M,double scale,double *w,int isize);

void Scwt_thierry_r(double *input, double *Oreal, double *Oimage,
   int *pnboctave, int *pnbvoice, int *pinputsize, int *pM);

void Scwt_thierry(double *Rinput,double *Iinput,double *Oreal,
   double *Oimage,int *pnboctave,int *pnbvoice,
   int *pinputsize,int *pM);

void Svwt_thierry(double *Rinput,double *Iinput,double *Oreal,
   double *Oimage,double *pa,int *pinputsize,
   int *pM);



/* In cwt_DOG.c
   ------------*/
void DOG_frequency(int M,double scale,double *w,int isize);

void Scwt_DOG_r(double *input, double *Oreal, double *Oimage,
   int *pnboctave, int *pnbvoice, int *pinputsize, int *pM);

void Scwt_DOG(double *Rinput,double *Iinput,double *Oreal,
   double *Oimage,int *pnboctave,int *pnbvoice,
   int *pinputsize,int *pM);

void Svwt_DOG(double *Rinput,double *Iinput,double *Oreal,
   double *Oimage,double *pa,int *pinputsize,
   int *pM);



/* In icm.c
   --------*/
void Sridge_icm(double *cost, double *smodulus, double *phi,
  double *plambda, double *pmu, int *psigsize, int *pnscale,
  int *piteration,int *pcount, int *psub, int *psmodsize);




/* In gabor.c
   ----------*/
void gabor_frequency(double sigma,double frequency,double *w,int isize);

void Sgabor(double *input, double *Oreal, double *Oimage, int *pnbfreq,
   double *pfreqstep, int *pinputsize, double *pscale);

void Svgabor(double *input,double *Oreal,double *Oimage,double *pfreq,
	int *pinputsize,double *pscale);

void vgabor_time(double *frequency,double *pscale, int *b, 
		 double *g_r, double *g_i,int *pisize, int *pnbnode);



/* In randomwalker.c
   -----------------*/
double ran1(long *idum);

void randomwalker(int sigsize,int *num);

void randomsnaker(int sigsize,int *num);

void randomwalker2(int sigsize,int *num, long *seed);



/* In randomwalker.c
   -----------------*/
double oldran1(long *idum);



/* In smoothwt.c
   -------------*/
void smoothwt(double *wt, double *swt, int sigsize, int nbscale,
   int windowlength);

void smoothwt1(double *wt, double *swt, int sigsize, int nbscale,
   int windowlength);

void smoothwt2(double *wt, double *swt, int sigsize, int nbscale,
   int windowlength, int *smodsize);

void Smodulus_smoothing(double *modulus, double *smodulus, 
  int *psigsize, int *psmodsize, int *pnscale, int *psubrate);

void Ssmoothwt(double *smodulus,double * modulus, int *psigsize,
   int *pnscale, int *psubrate, int *pflag);



/* In splridge.c
   -------------*/
void splridge(int rate, double *y, int n, double *yy);



/* In splsnake.c
   -------------*/
void splsnake(int rate, double *x, double *y, int n, double *yy);    



/* In snakesub.c
   -------------*/
void snakesub(double *rho,int rate,int snakesize);

void snakexpand(double *rho,int rate,int snakesize);



/* In ridge_annealing.c
   --------------------*/
void Sridge_annealing(double *cost, double *smodulus,
  double *phi, double *plambda, double *pmu, double *pc, int *psigsize,
  int *pnscale, int *piteration, int *pstagnant, int *pseed,
  int *pcount, int *psub, int *pblocksize, int *psmodsize);



/* In ridge_coronoid.c
   -------------------*/
void Sridge_coronoid(double *cost, double *smodulus,
  double *phi, double *plambda, double *pmu, double *pc, int *psigsize,
  int *pnscale, int *piteration, int *pstagnant, int *pseed,
  int *pcount, int *psub, int *pblocksize, int *psmodsize);


/* In snake_annealing.c
   --------------------*/
void Ssnake_annealing(double *cost, double *smodulus,
  double *phi, double *rho, double *plambda, double *pmu,
  double *plambda2, double *pmu2, double *pc, int *psigsize,
  int *psnakesize, int *pnscale, int *piteration,
  int *pstagnant, int *pseed, int *pcount, int *psub,
  int *pblocksize, int *psmodsize);


/* In multiply.c
   -------------*/
void multiply(double *Ri1, double *Ii1, double *Ri2, double *Ii2,
   double *Or,double *Oi, int isize);



/* In spline.c
   -----------*/
void spline(double x[], double y[], int n, double yp1, double ypn,
   double y2[]);



/* In splint.c
   -----------*/
void splint(double xa[], double ya[], double y2a[], int n, double x, double *y);



/* In splint2.c
   ------------*/
void splint2(double xa[], double ya[], double y2a[], int n, double x,
   double *y, double *yp);



/* In Util_denoising.c
   -------------------*/
int find2power(int n);

/******************* edit by xian Mon 14 Dec 2009 09:14:33 PM MST  ******
void error(char *s);
******************** edit by xian *****/




/* In bee_annealing.c
   ------------------*/
void Sbee_annealing(double *smodulus, double *beemap,
	       double *pc,
	       int *psigsize, int *pnscale, int *piteration,
               int *pseed, int *pbstep, int *pnbbee,
               int *pintegral, int *pchain, int *flag);

/* In ridrep.c
   -----------*/
void ridrep(double *signal,double *transform,double *phi,int length,
   int width, int bmin, int bmax, int amin, int amax,char *filename);

void snakerep(double *signal,double *transform,double *phi,double *rho,
   int nb_nodes,int length,int width, int bmin, int bmax, int amin, 
   int amax,char *filename);

void marsrep(double *signal,double *transform,double *phi, int length,
   int width, int b_start, int b_end, int bmin, int bmax, int amin,
   int amax,char *filename);



/* In delog.c
   ----------*/
void delog(double *phi, double *phi2, int A, int nvoice, int B);

void delog_inv(double *phi, double *phi2, int A, int nvoice, int B);



/* In initialization.c
   -------------------*/
void initialization(int *b_start , int *b_end,int *nitermax,
   double *a_0, int *rate);


/* In ridrecon.c
   -------------
void ridrecon(double *ridge, double *skel,double *signal, wave *W,
   int start, int end, double omega);
   */


/* In variance.c
   -------------*/
double variance(double *signal, int length);


/* In normalize.c
   --------------*/
void normalize(double *signal, double norm, int length);

void dnormalize(double *signal, double norm, int length);


/* In V_pot.c
   ----------*/
void V_pot(double *modulus, double *V, int B, int A);


/* In clean.c
   ----------*/
void fclean(double *array,  int length);

void dclean(double *array,  int length);

void iclean(int *array,  int length);


/* In power_law.c
   --------------*/
void power_law(double *V, double alpha, double cst, int nscale, int nvoice);


/* In ridge_rec.c
   --------------*/
void Sridge_rec(double *chain, double *recsig, double *gabor, int *pnbchain,
   int *psigsize, int *pnfreq);


/* In crazy_family.c
   -----------------*/
void Scrazy_family(double *ridgemap,double *orderedmap,int *chain,
   int *pnbchain,int *psigsize,int *pnscale,int *pbstep,double *pthreshold);

void orderedmap_thresholded(double *orderedmap,int sigsize,int nscale,
   int *chain,int nbchain);

void chain_thresholded(double *mridge,int sigsize,int *chain,int *id,
   int nbchain,double threshold, int bstep);

void reordering(int *chain, int sigsize, int nbchain);


/* In transpose.c
   --------------*/
void transpose(double *inmat,  double *outmat, int length1, int length2);

void itranspose(int *inmat,  int *outmat, int length1, int length2);

void dtranspose(double *inmat,  double *outmat, int length1, int length2);


/* in simul.c
   --------- */
void local_mean(double *mean, double *s, int np );

double gasdev(long *idum);

double variance(double *s, int np );

double denominator(double *Wf, int np );

double numerator(double *Wf, int resoln, int np );

void normal_histo( double ***histo, int max_resoln, int sample_size );

void bootstrap_histo(double ***histo, double *s, int max_resoln,
  int sample_size );

void normal_pval_compute(double *pval, double *s, int *max_resoln_ptr,
  int *np_ptr, int *num_of_windows_ptr, int *window_size_ptr );

void bootstrap_pval_compute(double *pval, double *s, int *max_resoln_ptr,
  int *np_ptr, int *num_of_windows_ptr, int *window_size_ptr );

void nthresh_compute(double *nthresh, double *s, int *maxresoln_ptr,
  int *sample_size_ptr, double prct );

void bthresh_compute(double *bthresh, double *s, int *maxresoln_ptr,
  int *sample_size_ptr, double prct );

double p_value(double T, double **histo, int resoln, int histo_size );

void compute_pval_average(double *pval, double **p, int max_resoln, int np,
  int num_of_windows, int window_size );



/* in qcksrt.c
   ----------- */
void qcksrt(int n,double arr[]);


/* in WV.c
   ------- */
void freq_parity(double frequency,double *win,double *wout,
   int isize,int sign);

void WV_freq_mult(double frequency,double *Ri,double *Ii,
  double *Ro, double *Io,int isize);

void WV(double *input, double *Oreal,double *Oimage,int *pnbfreq,
   double *pfreqstep,int *pinputsize);



/* in optimize.c
   ------------- */
void Lpnorm(double *norm, double *p, double *Rmat, double *Imat,
   int *length, int *width);

void entropy(double *entr, double *Rmat, double *Imat,
   int *length, int *width);



