% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/friends.R
\name{get_friends}
\alias{get_friends}
\title{Get user IDs of accounts followed by target user(s).}
\usage{
get_friends(
  users,
  n = 5000,
  retryonratelimit = NULL,
  cursor = "-1",
  parse = TRUE,
  verbose = TRUE,
  token = NULL,
  page = lifecycle::deprecated()
)
}
\arguments{
\item{users}{Screen name or user ID of target user from which the
user IDs of friends (accounts followed BY target user) will be
retrieved.}

\item{n}{Desired number of results to return. Results are downloaded
in pages when \code{n} is large; the default value will download a single
page. Set \code{n = Inf} to download as many results as possible.

The Twitter API rate limits the number of requests you can perform
in each 15 minute period. The easiest way to download more than that is
to use \code{retryonratelimit = TRUE}.

You are not guaranteed to get exactly \code{n} results back. You will get
fewer results when tweets have been deleted or if you hit a rate limit.
You will get more results if you ask for a number of tweets that's not
a multiple of page size, e.g. if you request \code{n = 150} and the page
size is 200, you'll get 200 results back.}

\item{retryonratelimit}{If \code{TRUE}, and a rate limit is exhausted, will wait
until it refreshes. Most Twitter rate limits refresh every 15 minutes.
If \code{FALSE}, and the rate limit is exceeded, the function will terminate
early with a warning; you'll still get back all results received up to
that point. The default value, \code{NULL}, consults the option
\code{rtweet.retryonratelimit} so that you can globally set it to \code{TRUE},
if desired.

If you expect a query to take hours or days to perform, you should not
rely solely on \code{retryonratelimit} because it does not handle other common
failure modes like temporarily losing your internet connection.}

\item{cursor}{Which page of results to return. The default will return
the first page; you can supply the result from a previous call to
continue pagination from where it left off.}

\item{parse}{If \code{TRUE}, the default, returns a tidy data frame. Use \code{FALSE}
to return the "raw" list corresponding to the JSON returned from the
Twitter API.}

\item{verbose}{Show progress bars and other messages indicating current
progress?}

\item{token}{Use this to override authentication for
a single API call. In many cases you are better off changing the
default for all calls. See \code{\link[=auth_as]{auth_as()}} for details.}

\item{page}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use \code{cursor} instead.}
}
\value{
A tibble data frame with two columns, "from_id" for name or ID of target
user and "to_id" for accounts ID they follow.
}
\description{
Returns a list of user IDs for the accounts following BY one or
more specified users. \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\details{
Generally, you should not need to set \code{n} to more than 5,000 since Twitter
limits the number of people that you can follow (i.e. to follow more than
5,000 people at least 5,000 people need to follow you).
}
\note{
If a user is protected the API will omit all requests so you'll need
to find which user is protected. rtweet will warn you and the output will be \code{NA}.
}
\examples{
if (FALSE) {
  get_friends("ropensci")
}
}
\references{
\url{https://developer.twitter.com/en/docs/twitter-api/v1/accounts-and-users/follow-search-get-users/api-reference/get-friends-ids}
}
\seealso{
\code{\link{rtweet-deprecated}}
}
