% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string2factor.R
\name{step_string2factor}
\alias{step_string2factor}
\title{Convert Strings to Factors}
\usage{
step_string2factor(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  levels = NULL,
  ordered = FALSE,
  skip = FALSE,
  id = rand_id("string2factor")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{levels}{An options specification of the levels to be used
for the new factor. If left \code{NULL}, the sorted unique
values present when \code{bake} is called will be used.}

\item{ordered}{A single logical value; should the factor(s) be
ordered?}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_string2factor} will convert one or more character
vectors to factors (ordered or unordered).

\emph{Use this step only in special cases} (see Details) and instead convert
strings to factors before using any tidymodels functions.
}
\details{
\subsection{When should you use this step?}{

In most cases, if you are planning to use \code{step_string2factor()}
without setting \code{levels}, you will be better off converting
those character variables to factor variables \strong{before using a recipe}.

This can be done using \pkg{dplyr} with the following code

\if{html}{\out{<div class="sourceCode r">}}\preformatted{df <- mutate(df, across(where(is.character), as.factor))
}\if{html}{\out{</div>}}

During resampling, the complete set of values might
not be in the character data. Converting them to factors with
\code{step_string2factor()}  then will misconfigure the levels.

If the \code{levels} argument to \code{step_string2factor()}is used, it will
convert all variables affected by this step to have the same
levels. Because of this, you will need to know the full set of level
when you define the recipe.

Also, note that \code{\link[=prep]{prep()}} has an option \code{strings_as_factors} that
defaults to \code{TRUE}. This should be changed so that raw character
data will be applied to \code{step_string2factor()}. However, this step
can also take existing factors (but will leave them as-is).
}
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble with columns
\code{terms} (the selectors or variables selected) and \code{ordered} is
returned.
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(Sacramento, package = "modeldata")

# convert factor to string to demonstrate
Sacramento$city <- as.character(Sacramento$city)

rec <- recipe(~ city + zip, data = Sacramento)

make_factor <- rec \%>\%
  step_string2factor(city)

make_factor <- prep(make_factor,
  training = Sacramento
)

make_factor

# note that `city` is a factor in recipe output
bake(make_factor, new_data = NULL) \%>\% head()

# ...but remains a string in the data
Sacramento \%>\% head()
\dontshow{\}) # examplesIf}
}
\seealso{
Other dummy variable and encoding steps: 
\code{\link{step_bin2factor}()},
\code{\link{step_count}()},
\code{\link{step_date}()},
\code{\link{step_dummy_extract}()},
\code{\link{step_dummy_multi_choice}()},
\code{\link{step_dummy}()},
\code{\link{step_factor2string}()},
\code{\link{step_holiday}()},
\code{\link{step_indicate_na}()},
\code{\link{step_integer}()},
\code{\link{step_novel}()},
\code{\link{step_num2factor}()},
\code{\link{step_ordinalscore}()},
\code{\link{step_other}()},
\code{\link{step_regex}()},
\code{\link{step_relevel}()},
\code{\link{step_time}()},
\code{\link{step_unknown}()},
\code{\link{step_unorder}()}
}
\concept{dummy variable and encoding steps}
