% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{add_changepoints_to_plot}
\alias{add_changepoints_to_plot}
\title{Get layers to overlay significant changepoints on prophet forecast plot.}
\usage{
add_changepoints_to_plot(
  m,
  threshold = 0.01,
  cp_color = "red",
  cp_linetype = "dashed",
  trend = TRUE,
  ...
)
}
\arguments{
\item{m}{Prophet model object.}

\item{threshold}{Numeric, changepoints where abs(delta) >= threshold are
significant. (Default 0.01)}

\item{cp_color}{Character, line color. (Default "red")}

\item{cp_linetype}{Character or integer, line type. (Default "dashed")}

\item{trend}{Logical, if FALSE, do not draw trend line. (Default TRUE)}

\item{...}{Other arguments passed on to layers.}
}
\value{
A list of ggplot2 layers.
}
\description{
Get layers to overlay significant changepoints on prophet forecast plot.
}
\examples{
\dontrun{
plot(m, fcst) + add_changepoints_to_plot(m)
}

}
