% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_draws.R
\name{draws_summary}
\alias{draws_summary}
\alias{summarise_draws}
\alias{summarize_draws}
\alias{summarise_draws.draws}
\alias{summary.draws}
\alias{summarise_draws.rvar}
\alias{summary.rvar}
\alias{default_summary_measures}
\alias{default_convergence_measures}
\alias{default_mcse_measures}
\title{Summaries of \code{draws} objects}
\usage{
summarise_draws(.x, ...)

summarize_draws(.x, ...)

\method{summarise_draws}{draws}(
  .x,
  ...,
  .args = list(),
  .num_args = getOption("posterior.num_args", list()),
  .cores = 1
)

\method{summary}{draws}(object, ...)

\method{summarise_draws}{rvar}(.x, ...)

\method{summary}{rvar}(object, ...)

default_summary_measures()

default_convergence_measures()

default_mcse_measures()
}
\arguments{
\item{.x, object}{(draws) A \code{draws} object or one coercible to a \code{draws} object.}

\item{...}{Name-value pairs of summary or \link[=diagnostics]{diagnostic}
functions. The provided names will be used as the names of the columns in
the result \emph{unless} the function returns a named vector, in which case the
latter names are used. The functions can be specified in any format
supported by \link[rlang:as_function]{as_function()}. See \strong{Examples}.}

\item{.args}{(named list) Optional arguments passed to the summary functions.}

\item{.num_args}{(named list) Optional arguments passed to
\link[tibble:num]{num()} for pretty printing of summaries. Can be controlled
globally via the \code{posterior.num_args} \link[base:options]{option}.}

\item{.cores}{(positive integer) The number of cores to use for computing
summaries for different variables in parallel. Coerced to integer if
possible, otherwise errors. The default is \code{.cores = 1}, in which case no
parallelization is implemented. By default, a socket cluster is used on
Windows and forks otherwise.}
}
\value{
The \code{summarise_draws()} methods return a \link[tibble:tibble]{tibble} data frame.
The first column (\code{"variable"}) contains the variable names and the remaining
columns contain summary statistics and diagnostics.

The functions \code{default_summary_measures()}, \code{default_convergence_measures()},
and \code{default_mcse_measures()} return character vectors of names of the
default measures.
}
\description{
The \code{summarise_draws()} (and \code{summarize_draws()}) methods provide a quick way
to get a table of summary statistics and diagnostics. These methods will
convert an object to a \code{draws} object if it isn't already. For convenience, a
\link[base:summary]{summary()} method for \code{draws} and \code{rvar} objects are also
provided as an alias for \code{summarise_draws()} if the input object is a \code{draws}
or \code{rvar} object.
}
\details{
The default summary functions used are the ones specified by
\code{default_summary_measures()} and \code{default_convergence_measures()}:

\code{default_summary_measures()}
\itemize{
\item \code{\link[=mean]{mean()}}
\item \code{\link[=median]{median()}}
\item \code{\link[=sd]{sd()}}
\item \code{\link[=mad]{mad()}}
\item \code{\link[=quantile2]{quantile2()}}
}

\code{default_convergence_measures()}
\itemize{
\item \code{\link[=rhat]{rhat()}}
\item \code{\link[=ess_bulk]{ess_bulk()}}
\item \code{\link[=ess_tail]{ess_tail()}}
}

The \code{var()} function should not be used to compute variances due
to its inconsistent behavior with matrices. Instead, please use
\code{distributional::variance()}.
}
\examples{
x <- example_draws("eight_schools")
class(x)
str(x)

summarise_draws(x)
summarise_draws(x, "mean", "median")
summarise_draws(x, mean, mcse = mcse_mean)
summarise_draws(x, ~quantile(.x, probs = c(0.4, 0.6)))

# using default_*_meaures()
summarise_draws(x, default_summary_measures())
summarise_draws(x, default_convergence_measures())
summarise_draws(x, default_mcse_measures())

# compute variance of variables
summarise_draws(x, var = distributional::variance)

# illustrate use of '.args'
ws <- rexp(ndraws(x))
summarise_draws(x, weighted.mean, .args = list(w = ws))

# adjust how numerical summaries are printed
summarise_draws(x, .num_args = list(sigfig = 2, notation = "dec"))

}
\seealso{
\code{\link{diagnostics}} for a list of available diagnostics and links to
their individual help pages.
}
