% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lissajous.R
\name{lissajous}
\alias{lissajous}
\title{Lissajous polynomials}
\usage{
lissajous(m, n, p, q, digits = 3)
}
\arguments{
\item{m, n, p, q}{Trigonometric coefficients, see examples for description}

\item{digits}{The number of digits to round coefficients to, see
\code{\link[=round.mpoly]{round.mpoly()}}. This is useful for cleaning terms that are numerically
nonzero, but should be.}
}
\value{
a mpoly object
}
\description{
The Lissajous polynomials are the implicit (variety) descriptions of the
image of the parametric map x = cos(m t + p), y = sin(n t + q).
}
\examples{

lissajous(3, 2,  -pi/2, 0)
lissajous(4, 3,  -pi/2, 0)

}
\seealso{
\code{\link[=chebyshev]{chebyshev()}}, Merino, J. C (2003). Lissajous figures and Chebyshev
polynomials. The College Mathematics Journal, 34(2), pp. 122-127.
}
