/*
 * Decompiled with CFR 0.152.
 */
package main;

import analysis.Analysis;
import analysis.VarPairQueue;
import analysis.results.BriefResult;
import analysis.results.Result;
import data.Dataset;
import data.VarPair;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import main.JobParameters;

public class Analyze {
    private static FileWriter outfile;
    private static BufferedWriter out;
    private static final String version = "1.0.1d";

    public static void main(String[] args) throws IOException {
        if (args.length > 0 && (args[0] == "-?" || args[0] == "-h" || args[0] == "/h" || args[0] == "/?")) {
            JobParameters.printManPage("you asked for help");
            System.out.println();
            return;
        }
        JobParameters params = null;
        try {
            params = new JobParameters(args);
        }
        catch (IllegalArgumentException e) {
            JobParameters.printManPage(e.toString());
            return;
        }
        System.out.println(Analyze.header());
        System.out.println();
        System.out.println(params);
        System.out.println();
        Result[] results = Analyze.runAnalysis(params);
        System.out.println("done.");
        System.out.println("Printing all results !!!with MIC > 0.0000001...!!!");
        while (!Analyze.printResults(results, params)) {
            System.out.println("Error writing output to file. Perhaps it is open or locked");
            System.out.print("in some way. Try again? (y or n): ");
            int yes = 110;
            try {
                yes = (char)System.in.read();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            if (yes != 110) continue;
        }
        System.out.println("All done. Goodbye!");
    }

    public static Result[] runAnalysis(JobParameters params) throws IOException {
        System.out.println("Reading in dataset...");
        Dataset d = new Dataset(params.inputfile, params.analysisParams.mineParams.debug);
        VarPairQueue toAnalyze = new VarPairQueue(d);
        params.analysisStyle.addVarPairsTo(toAnalyze, d.numVariables());
        Analysis a = new Analysis(d, toAnalyze);
        System.out.println("Analyzing...");
        while (!a.varPairQueue().isEmpty()) {
            String statusUpdate = String.valueOf(a.numResults() + 1) + " calculating: " + ((VarPair)a.varPairQueue().peek()).var1.name() + " vs " + ((VarPair)a.varPairQueue().peek()).var2.name() + "...";
            System.out.println(statusUpdate);
            try {
                FileWriter statusfile = new FileWriter(params.statusFileName());
                BufferedWriter status = new BufferedWriter(statusfile);
                status.write(statusUpdate);
                status.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            a.analyzePairs(BriefResult.class, params.analysisParams, params.notifyWait);
        }
        System.out.println(String.valueOf(a.numResults()) + " variable pairs analyzed");
        System.out.println("Sorting results in descending order...");
        return a.getSortedResults();
    }

    public static boolean printResults(Result[] results, JobParameters params) {
        return Analyze.printResults(results, params.resultsFileName());
    }

    public static boolean printResults(Result[] results, String outfilename) {
        try {
            outfile = new FileWriter(outfilename);
            out = new BufferedWriter(outfile);
            out.write(String.valueOf(results[0].getHeader()) + "\n");
            int i = 0;
            while (i < results.length) {
                if (results[i].worthMentioning()) {
                    out.write(results[i].toString());
                    out.newLine();
                    out.flush();
                }
                ++i;
            }
            out.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String header() {
        return "**********************************************************\n" + Analyze.versionDescription() + "\n" + Analyze.copyrightNotice() + "\n" + "**********************************************************\n";
    }

    public static String copyrightNotice() {
        return "Copyright 2011 by David Reshef and Yakir Reshef.\n\nThis application is licensed under a Creative Commons\nAttribution-NonCommercial-NoDerivs 3.0 Unported License.\nSee\nhttp://creativecommons.org/licenses/by-nc-nd/3.0/ for\nmore information.";
    }

    public static String versionDescription() {
        return "MINE version 1.0.1d";
    }
}

