% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipw.R
\name{ipw2}
\alias{ipw2}
\title{Inverse Probability of Censoring Weights}
\usage{
ipw2(
  data,
  times = NULL,
  entrytime = NULL,
  time = "time",
  cause = "cause",
  same.cens = FALSE,
  cluster = NULL,
  pairs = FALSE,
  strata = NULL,
  obs.only = TRUE,
  cens.formula = NULL,
  cens.code = 0,
  pair.cweight = "pcw",
  pair.tweight = "ptw",
  pair.weight = "weights",
  cname = "cweights",
  tname = "tweights",
  weight.name = "indi.weights",
  prec.factor = 100,
  ...
)
}
\arguments{
\item{data}{data frame}

\item{times}{possible time argument for speciying a maximum value of time tau=max(times), to specify when things are considered censored or not.}

\item{entrytime}{nam of entry-time for truncation.}

\item{time}{name of time variable on data frame.}

\item{cause}{name of cause indicator on data frame.}

\item{same.cens}{For clustered data, should same censoring be assumed and same truncation (bivariate probability calculated as mininum of the marginal probabilities)}

\item{cluster}{name of clustering variable}

\item{pairs}{For paired data (e.g. twins) only the complete pairs are returned (With pairs=TRUE)}

\item{strata}{name of strata variable to get weights stratified.}

\item{obs.only}{Return data with uncensored observations only}

\item{cens.formula}{model for Cox models for truncation and right censoring times.}

\item{cens.code}{censoring.code}

\item{pair.cweight}{Name of weight variable in the new data.frame for right censorig of pairs}

\item{pair.tweight}{Name of weight variable in the new data.frame for left truncation of pairs}

\item{pair.weight}{Name of weight variable in the new data.frame for right censoring and left truncation of pairs}

\item{cname}{Name of weight variable in the new data.frame for right censoring of individuals}

\item{tname}{Name of weight variable in the new data.frame for left truncation of individuals}

\item{weight.name}{Name of weight variable in the new data.frame for right censoring and left truncation of individuals}

\item{prec.factor}{To let tied censoring and truncation times come after the death times.}

\item{...}{Additional arguments to censoring model}
}
\description{
Internal function.
Calculates Inverse Probability of Censoring and Truncation 
Weights and adds them to a data.frame
}
\examples{
library("timereg")
set.seed(1)
d <- simnordic.random(5000,delayed=TRUE,ptrunc=0.7,
      cordz=0.5,cormz=2,lam0=0.3,country=FALSE)
d$strata <- as.numeric(d$country)+(d$zyg=="MZ")*4
times <- seq(60,100,by=10)
c1 <- comp.risk(Event(time,cause)~1+cluster(id),data=d,cause=1,
	model="fg",times=times,max.clust=NULL,n.sim=0)
mm=model.matrix(~-1+zyg,data=d)
out1<-random.cif(c1,data=d,cause1=1,cause2=1,same.cens=TRUE,theta.des=mm)
summary(out1)
pc1 <- predict(c1,X=1,se=0)
plot(pc1)

dl <- d[!d$truncated,]
dl <- ipw2(dl,cluster="id",same.cens=TRUE,time="time",entrytime="entry",cause="cause",
           strata="strata",prec.factor=100)
cl <- comp.risk(Event(time,cause)~+1+
		cluster(id),
		data=dl,cause=1,model="fg",
		weights=dl$indi.weights,cens.weights=rep(1,nrow(dl)),
            times=times,max.clust=NULL,n.sim=0)
pcl <- predict(cl,X=1,se=0)
lines(pcl$time,pcl$P1,col=2)
mm=model.matrix(~-1+factor(zyg),data=dl)
out2<-random.cif(cl,data=dl,cause1=1,cause2=1,theta.des=mm,
                 weights=dl$weights,censoring.weights=rep(1,nrow(dl)))
summary(out2)
}
\author{
Thomas Scheike
}
