% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memoise.R
\name{drop_cache}
\alias{drop_cache}
\title{Drops the cache of a memoised function for particular arguments.}
\usage{
drop_cache(f)
}
\arguments{
\item{f}{Memoised function.}
}
\value{
A function, with the same arguments as \code{f}, that can be called to drop
  the cached results of \code{f}.
}
\description{
Drops the cache of a memoised function for particular arguments.
}
\examples{
mem_sum <- memoise(sum)
mem_sum(1, 2, 3)
mem_sum(2, 3, 4)
has_cache(mem_sum)(1, 2, 3) # TRUE
has_cache(mem_sum)(2, 3, 4) # TRUE
drop_cache(mem_sum)(1, 2, 3) # TRUE
has_cache(mem_sum)(1, 2, 3) # FALSE
has_cache(mem_sum)(2, 3, 4) # TRUE
}
\seealso{
\code{\link{has_cache}}, \code{\link{memoise}}
}
