% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_HeliosOSL2R.R
\name{read_HeliosOSL2R}
\alias{read_HeliosOSL2R}
\title{Import Luminescence Data from Helios Luminescence Reader}
\usage{
read_HeliosOSL2R(file, verbose = TRUE, ...)
}
\arguments{
\item{file}{\link{character} (\strong{required}): path to file to be imported. Can be a \link{list}
for further processing}

\item{verbose}{\link{logical} (\emph{with default}): enable/disable output to the
terminal.}

\item{...}{not in use, for compatibility reasons only}
}
\value{
\linkS4class{RLum.Analysis} object
}
\description{
Straightforward import of files with the ending \code{.osl} produced
by the zero rad Helios luminescence reader and conversion to \linkS4class{RLum.Analysis} objects.
}
\note{
Thanks to Krzysztof Maternicki for providing example data.
}
\section{Function version}{
 0.1.0
}

\examples{
file <- system.file("extdata/HeliosOSL_Example.osl", package = "Luminescence")
read_HeliosOSL2R(file)

}
\seealso{
\linkS4class{RLum.Data.Curve}, \linkS4class{RLum.Analysis}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2025. read_HeliosOSL2R(): Import Luminescence Data from Helios Luminescence Reader. Function version 0.1.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.0.1. https://r-lum.github.io/Luminescence/
}

\keyword{IO}
