% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_PSL2CSV.R
\name{convert_PSL2CSV}
\alias{convert_PSL2CSV}
\title{Export PSL-file(s) to CSV-files}
\usage{
convert_PSL2CSV(file, extract_raw_data = FALSE, single_table = FALSE, ...)
}
\arguments{
\item{file}{\link{character} (\strong{required}):
name of the PSL-file to be converted to CSV-files}

\item{extract_raw_data}{\link{logical} (\emph{with default}): enable/disable raw data
extraction. The PSL files imported into R contain an element \verb{$raw_data}, which
provides a few more information (e.g., count errors), sometimes it makes
sense to use this data of the more compact standard values created by \link{read_PSL2R}}

\item{single_table}{\link{logical} (\emph{with default}): enable/disable the creation
of single table with n rows and n columns, instead of separate \link{data.frame}
objects. Each curve will be represented by two columns for time and counts}

\item{...}{further arguments that will be passed to the function
\link{read_PSL2R} and \link{write_RLum2CSV}}
}
\value{
The function returns either a CSV-file (or many of them) or for the option
\code{export = FALSE} a list comprising objects of type \link{data.frame} and \link{matrix}
}
\description{
This function is a wrapper function around the functions \link{read_PSL2R} and
\link{write_RLum2CSV} and it imports an PSL-file (SUERC portable OSL reader file format)
and directly exports its content to CSV-files.
If nothing is set for the argument \code{path} (\link{write_RLum2CSV}) the input folder will
become the output folder.
}
\section{Function version}{
 0.1.2
}

\examples{

## export into single data.frame
file <- system.file("extdata/DorNie_0016.psl", package="Luminescence")
convert_PSL2CSV(file, export = FALSE, single_table = TRUE)


\dontrun{
##select your BIN-file
file <- file.choose()

##convert
convert_PSL2CSV(file)

}

}
\seealso{
\linkS4class{RLum.Analysis}, \linkS4class{RLum.Data}, \linkS4class{RLum.Results},
\link[utils:write.table]{utils::write.table}, \link{write_RLum2CSV}, \link{read_PSL2R}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2025. convert_PSL2CSV(): Export PSL-file(s) to CSV-files. Function version 0.1.2. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.0.1. https://r-lum.github.io/Luminescence/
}

\keyword{IO}
