% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{dshape3dProp}
\alias{dshape3dProp}
\title{3d Kernel density estimation for data classified in polygons or shapes}
\usage{
dshape3dProp(
  data,
  burnin = 2,
  samples = 5,
  shapefile,
  gridsize = 200,
  boundary = FALSE,
  deleteShapes = NULL,
  fastWeights = TRUE,
  numChains = 1,
  numThreads = 1
)
}
\arguments{
\item{data}{data.frame with 5 columns: x-coordinate, y-coordinate (i.e. center of polygon) and number of observations in area for partial population and number of observations for complete observations and third variable (numeric).}

\item{burnin}{burn-in sample size}

\item{samples}{sampling iteration size}

\item{shapefile}{shapefile with number of polygons equal to nrow(data) / length(unique(data[,5]))}

\item{gridsize}{number of evaluation grid points}

\item{boundary}{boundary corrected kernel density estimate?}

\item{deleteShapes}{shapefile containing areas without observations}

\item{fastWeights}{if TRUE weigths for boundary estimation are only computed for first 10 percent of samples to speed up computation}

\item{numChains}{number of chains of SEM algorithm}

\item{numThreads}{number of threads to be used (only applicable if more than one chains)}
}
\description{
3d Kernel density estimation for data classified in polygons or shapes
}
