% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fit.R, R/get_info.R
\name{get_fit}
\alias{get_fit}
\alias{get_fit.incidence_fit}
\alias{get_fit.incidence_fit_list}
\alias{get_info}
\alias{get_info.incidence_fit}
\alias{get_info.incidence_fit_list}
\title{Accessors for \code{incidence_fit} objects}
\usage{
get_fit(x)

\method{get_fit}{incidence_fit}(x)

\method{get_fit}{incidence_fit_list}(x)

get_info(x, what = "r", ...)

\method{get_info}{incidence_fit}(x, what = "r", ...)

\method{get_info}{incidence_fit_list}(x, what = "r", groups = NULL, na.rm = TRUE, ...)
}
\arguments{
\item{x}{an \code{incidence_fit} or \code{incidence_fit_list}
object.}

\item{what}{the name of the item in the "info" element of the \code{incidence_fit}
object.}

\item{...}{currently unused.}

\item{groups}{if \code{what = "pred"} and \code{x} is an \code{incidence_fit_list} object,
then this indicates what part of the nesting hierarchy becomes the column
named "groups". Defaults to \code{NULL}, indicating that no groups column will
be added/modified.}

\item{na.rm}{when \code{TRUE} (default), missing values will be excluded from the
results.}
}
\value{
a list of \code{incidence_fit} objects.
}
\description{
Accessors for \code{incidence_fit} objects
}
\examples{

if (require(outbreaks)) { withAutoprint({

 dat <- ebola_sim$linelist$date_of_onset

 ## EXAMPLE WITH A SINGLE MODEL

 ## compute weekly incidence
 sex <- ebola_sim$linelist$gender
 i.sex <- incidence(dat, interval = 7, group = sex)
 
 ## Compute the optimal split for each group separately
 fits  <- fit_optim_split(i.sex, separate_split = TRUE)

 ## `fits` contains an `incidence_fit_list` object
 fits$fit
 
 ## Grab the list of `incidence_fit` objects
 get_fit(fits$fit)
 
 ## Get the predictions for all groups
 get_info(fits$fit, "pred", groups = 1)
 
 ## Get the predictions, but set `groups` to "before" and "after"
 get_info(fits$fit, "pred", groups = 2)
 
 ## Get the reproduction number
 get_info(fits$fit, "r")

 ## Get the doubling confidence interval
 get_info(fits$fit, "doubling.conf")

 ## Get the halving confidence interval
 get_info(fits$fit, "halving.conf")
})}
}
