% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/req-url.R
\name{req_url}
\alias{req_url}
\alias{req_url_query}
\alias{req_url_path}
\alias{req_url_path_append}
\title{Modify request URL}
\usage{
req_url(req, url)

req_url_query(.req, ...)

req_url_path(req, ...)

req_url_path_append(req, ...)
}
\arguments{
\item{req, .req}{A \link{request}.}

\item{url}{New URL; completely replaces existing.}

\item{...}{For \code{req_url_query()}: Name-value pairs that provide query
parameters. Each value must be either a length-1 atomic vector
(which is automatically escaped) or \code{NULL} (which is silently dropped).
If you want to opt out of escaping, wrap strings in \code{I()}.

For \code{req_url_path()} and \code{req_url_path_append()}: A sequence of path
components that will be combined with \code{/}.}
}
\value{
A modified HTTP \link{request}.
}
\description{
\itemize{
\item \code{req_url()} replaces the entire url
\item \code{req_url_query()} modifies the components of the query
\item \code{req_url_path()} modifies the path
\item \code{req_url_path_append()} adds to the path
}
}
\examples{
req <- request("http://example.com")

# Change url components
req \%>\%
  req_url_path_append("a") \%>\%
  req_url_path_append("b") \%>\%
  req_url_path_append("search.html") \%>\%
  req_url_query(q = "the cool ice")

# Change complete url
req \%>\%
  req_url("http://google.com")
}
