% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth-client.R
\name{oauth_client}
\alias{oauth_client}
\title{Create an OAuth client}
\usage{
oauth_client(
  id,
  token_url,
  secret = NULL,
  key = NULL,
  auth = c("body", "header", "jwt_sig"),
  auth_params = list(),
  name = hash(id)
)
}
\arguments{
\item{id}{Client identifier.}

\item{token_url}{Url to retrieve an access token.}

\item{secret}{Client secret. For most apps, this is technically confidential
so in principle you should avoid storing it in source code. However, many
APIs require it in order to provide a user friendly authentication
experience, and the risks of including it are usually low. To make things
a little safer, I recommend using \code{\link[=obfuscate]{obfuscate()}} when recorded the client
secret in public code.}

\item{key}{Client key. As an alternative to using a \code{secret}, you can
instead supply a confidential private key. This should never be included
in a package.}

\item{auth}{Authentication mechanism used by the client to prove itself to
the API. Can be one of three built-in methods ("body", "header", or "jwt"),
or a function that will be called with arguments \code{req}, \code{client}, and
the contents of \code{auth_params}.

The most common mechanism in the wild is \code{"body"} where the \code{client_id} and
(optionally) \code{client_secret} are added to the body. \code{"header"} sends in
\code{client_id} and \code{client_secret} in HTTP Authorization header. \code{"jwt_sig"}
will generate a JWT, and include it in a \code{client_assertion} field in the
body.

See \code{\link[=oauth_client_req_auth]{oauth_client_req_auth()}} for more details.}

\item{auth_params}{Additional parameters passed to the function specified
by \code{auth}.}

\item{name}{Optional name for the client. Used when generating cache
directory. If \code{NULL}, generated from hash of \code{client_id}. If you're
defining a package for use in a package, I recommend that you use
the package name.}
}
\value{
An OAuth client: An S3 list with class \code{httr2_oauth_client}.
}
\description{
An OAuth app is the combination of a client, a set of endpoints
(i.e. urls where various requests should be sent), and an authentication
mechanism. A client consists of at least a \code{client_id}, and also often
a \code{client_secret}. You'll get these values when you create the client on
the API's website.
}
\examples{
oauth_client("myclient", "http://example.com/token_url", secret = "DONTLOOK")
}
