% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remote.R
\name{remote}
\alias{remote}
\title{Create a remote future whose value will be resolved asynchronously in a remote process}
\usage{
remote(
  ...,
  workers = NULL,
  revtunnel = TRUE,
  myip = NULL,
  persistent = TRUE,
  envir = parent.frame()
)
}
\arguments{
\item{...}{Additional named elements passed to \code{\link[=Future]{Future()}}.}

\item{workers}{A \code{\link[parallel:makeCluster]{cluster}} object,
a character vector of host names, a positive numeric scalar,
or a function.
If a character vector or a numeric scalar, a \code{cluster} object
is created using \code{\link{makeClusterPSOCK}(workers)}.
If a function, it is called without arguments \emph{when the future
is created} and its value is used to configure the workers.
The function should return any of the above types.}

\item{revtunnel}{If TRUE, reverse SSH tunneling is used for the
PSOCK cluster nodes to connect back to the master \R process.  This
avoids the hassle of firewalls, port forwarding and having to know
the internal / public IP address of the master \R session.}

\item{myip}{The external IP address of this machine.
If NULL, then it is inferred using an online service (default).}

\item{persistent}{If FALSE, the evaluation environment is cleared
from objects prior to the evaluation of the future.}

\item{envir}{The \link{environment} from where global objects should be
identified.}
}
\value{
A \link{ClusterFuture}.
}
\description{
A remote future is a future that uses remote cluster evaluation,
which means that its \emph{value is computed and resolved
remotely in another process}.
}
\section{'remote' versus 'cluster'}{

The \code{remote} plan is a very similar to the \code{\link{cluster}} plan, but provides
more convenient default argument values when connecting to remote machines.  Specifically,
\code{remote} uses \code{persistent = TRUE} by default, and it sets \code{homogeneous},
\code{revtunnel}, and \code{myip} "wisely" depending on the value of \code{workers}.
See below for example on how \code{remote} and \code{cluster} are related.
}

\examples{
\dontrun{\donttest{

## Use a remote machine
plan(remote, workers = "remote.server.org")

## Evaluate expression remotely
host \%<-\% { Sys.info()[["nodename"]] }
host
[1] "remote.server.org"


## The following setups are equivalent:
plan(remote, workers = "localhost")
plan(cluster, workers = "localhost", persistent = TRUE)
plan(cluster, workers = 1, persistent = TRUE)
plan(multisession, workers = 1, persistent = TRUE)

## The following setups are equivalent:
plan(remote, workers = "remote.server.org")
plan(cluster, workers = "remote.server.org", persistent = TRUE, homogeneous = FALSE)

## The following setups are equivalent:
cl <- makeClusterPSOCK("remote.server.org")
plan(remote, workers = cl)
plan(cluster, workers = cl, persistent = TRUE)

}}
}
